/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref.boundary;

import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import openlr.map.utils.GeometryUtils;
import openlr.rawLocRef.RawCircleLocRef;
import openlr.rawLocRef.RawClosedLineLocRef;
import openlr.rawLocRef.RawGeoCoordLocRef;
import openlr.rawLocRef.RawGridLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPoiAccessLocRef;
import openlr.rawLocRef.RawPointAlongLocRef;
import openlr.rawLocRef.RawPolygonLocRef;
import openlr.rawLocRef.RawRectangleLocRef;
import openlr.utils.locref.LocationReferenceProcessor;
import openlr.utils.locref.boundary.BoundingBoxCalculator;
import openlr.utils.locref.boundary.CircleBoundingBoxCalculator;
import openlr.utils.locref.boundary.LrpBbasedBoundigBoxCalculator;
import openlr.utils.locref.boundary.PolygonBoundingBoxCalculator;

final class BoundingBoxCalculatorFactory
extends LocationReferenceProcessor<BoundingBoxCalculator> {
    BoundingBoxCalculatorFactory() {
    }

    @Override
    public BoundingBoxCalculator process(RawLineLocRef locRef) {
        return new LrpBbasedBoundigBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator process(RawGeoCoordLocRef locRef) {
        return new BoundingBoxCalculator(){
            private static final double OFFSET_UPPER_RGHT = 1.0E-5;

            @Override
            public RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
                GeoCoordinates coordinate = locRef.getGeoCoordinates();
                GeoCoordinatesImpl upperRight = new GeoCoordinatesImpl(coordinate.getLongitudeDeg() + 1.0E-5, coordinate.getLatitudeDeg() + 1.0E-5);
                return new RectangleCorners(coordinate, (GeoCoordinates)upperRight);
            }
        };
    }

    @Override
    public BoundingBoxCalculator process(RawPointAlongLocRef locRef) {
        return new LrpBbasedBoundigBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator process(RawPoiAccessLocRef locRef) {
        return new LrpBbasedBoundigBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator process(RawRectangleLocRef locRef) {
        return new BoundingBoxCalculator(){

            @Override
            public RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
                return new RectangleCorners(locRef.getLowerLeftPoint(), locRef.getUpperRightPoint());
            }
        };
    }

    @Override
    public BoundingBoxCalculator process(RawPolygonLocRef locRef) {
        return new PolygonBoundingBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator process(RawCircleLocRef locRef) {
        return new CircleBoundingBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator process(RawGridLocRef locRef) {
        return new BoundingBoxCalculator(){

            @Override
            public RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
                GeoCoordinates lowerLeft = locRef.getLowerLeftPoint();
                GeoCoordinates upperRight = locRef.getUpperRightPoint();
                GeoCoordinates scaledUpperRight = GeometryUtils.scaleUpperRightCoordinate((double)lowerLeft.getLongitudeDeg(), (double)lowerLeft.getLatitudeDeg(), (double)upperRight.getLongitudeDeg(), (double)upperRight.getLatitudeDeg(), (double)locRef.getNumberOfColumns(), (double)locRef.getNumberOfRows());
                return new RectangleCorners(lowerLeft, scaledUpperRight);
            }
        };
    }

    @Override
    public BoundingBoxCalculator process(RawClosedLineLocRef locRef) {
        return new LrpBbasedBoundigBoxCalculator();
    }

    @Override
    public BoundingBoxCalculator processUnknown(RawLocationReference locationReference) {
        throw new IllegalArgumentException("Bounding box calculator called with location reference of type " + (Object)((Object)locationReference.getLocationType()));
    }
}

