/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref.boundary;

import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import openlr.map.utils.GeometryUtils;
import openlr.rawLocRef.RawLocationReference;
import openlr.utils.locref.boundary.BoundingBoxCalculator;

final class CircleBoundingBoxCalculator
implements BoundingBoxCalculator {
    private static final double METERS_PER_KILOMETER = 1000.0;

    CircleBoundingBoxCalculator() {
    }

    @Override
    public RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
        GeoCoordinates center = locRef.getCenterPoint();
        double lon = center.getLongitudeDeg();
        double lat = center.getLatitudeDeg();
        double radiusInKilometers = (double)locRef.getRadius() / 1000.0;
        double longLeft = GeometryUtils.determineCoordinateInDistance((double)lon, (double)lat, (int)270, (double)radiusInKilometers).getLongitudeDeg();
        double longRight = GeometryUtils.determineCoordinateInDistance((double)lon, (double)lat, (int)90, (double)radiusInKilometers).getLongitudeDeg();
        double latLeft = GeometryUtils.determineCoordinateInDistance((double)lon, (double)lat, (int)180, (double)radiusInKilometers).getLatitudeDeg();
        double latRight = GeometryUtils.determineCoordinateInDistance((double)lon, (double)lat, (int)0, (double)radiusInKilometers).getLatitudeDeg();
        return new RectangleCorners((GeoCoordinates)new GeoCoordinatesImpl(longLeft, latLeft), (GeoCoordinates)new GeoCoordinatesImpl(longRight, latRight));
    }
}

