/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref.boundary;

import openlr.LocationReferencePoint;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import openlr.map.utils.GeometryUtils;
import openlr.rawLocRef.RawLocationReference;
import openlr.utils.locref.boundary.BoundingBoxCalculator;
import openlr.utils.locref.boundary.Envelope;

class LrpBbasedBoundigBoxCalculator
implements BoundingBoxCalculator {
    private static final float ADDITIONAL_VARIANCE_KM = 0.06f;
    private static final float FACTOR_KM = 2000.0f;

    LrpBbasedBoundigBoxCalculator() {
    }

    public RectangleCorners calculateLocRefPointBoundary(RawLocationReference rawLocRef) throws InvalidMapDataException {
        Envelope envelope = new Envelope();
        if (rawLocRef.getLocationReferencePoints() == null) {
            return null;
        }
        for (LocationReferencePoint lrp : rawLocRef.getLocationReferencePoints()) {
            envelope.include(lrp.getLongitudeDeg(), lrp.getLatitudeDeg());
        }
        GeoCoordinatesImpl ll = new GeoCoordinatesImpl(envelope.getMinX(), envelope.getMinY());
        GeoCoordinatesImpl ur = new GeoCoordinatesImpl(envelope.getMaxX(), envelope.getMaxY());
        return new RectangleCorners((GeoCoordinates)ll, (GeoCoordinates)ur);
    }

    private RectangleCorners calculateLocRefBoundary(RawLocationReference rawLocRef) throws InvalidMapDataException {
        RectangleCorners rcMin = this.calculateLocRefPointBoundary(rawLocRef);
        if (rcMin != null) {
            double maxDist = this.calculateMaxDist(rawLocRef);
            return this.createMaximumRectangle(rcMin, maxDist);
        }
        return null;
    }

    private double calculateMaxDist(RawLocationReference lr) {
        double maxDist = 0.0;
        if (lr.getLocationReferencePoints() != null) {
            for (int i = 0; i < lr.getLocationReferencePoints().size() - 1; ++i) {
                LocationReferencePoint lrp = lr.getLocationReferencePoints().get(i);
                int dnp = lrp.getDistanceToNext();
                LocationReferencePoint next = lr.getLocationReferencePoints().get(i + 1);
                double dist = GeometryUtils.distance((double)lrp.getLongitudeDeg(), (double)lrp.getLatitudeDeg(), (double)next.getLongitudeDeg(), (double)next.getLatitudeDeg());
                double boundingBoxDist = ((double)dnp - dist) / 2000.0 + (double)0.06f;
                if (!(boundingBoxDist > maxDist)) continue;
                maxDist = boundingBoxDist;
            }
        }
        return maxDist;
    }

    private RectangleCorners createMaximumRectangle(RectangleCorners min, double distance) throws InvalidMapDataException {
        GeoCoordinates temp1 = GeometryUtils.determineCoordinateInDistance((double)min.getLowerLeft().getLongitudeDeg(), (double)min.getLowerLeft().getLatitudeDeg(), (int)180, (double)distance);
        GeoCoordinates temp2 = GeometryUtils.determineCoordinateInDistance((double)min.getLowerLeft().getLongitudeDeg(), (double)min.getLowerLeft().getLatitudeDeg(), (int)270, (double)distance);
        GeoCoordinatesImpl newLL = new GeoCoordinatesImpl(temp2.getLongitudeDeg(), temp1.getLatitudeDeg());
        GeoCoordinates temp3 = GeometryUtils.determineCoordinateInDistance((double)min.getUpperRight().getLongitudeDeg(), (double)min.getUpperRight().getLatitudeDeg(), (int)0, (double)distance);
        GeoCoordinates temp4 = GeometryUtils.determineCoordinateInDistance((double)min.getUpperRight().getLongitudeDeg(), (double)min.getUpperRight().getLatitudeDeg(), (int)90, (double)distance);
        GeoCoordinatesImpl newUR = new GeoCoordinatesImpl(temp4.getLongitudeDeg(), temp3.getLatitudeDeg());
        return new RectangleCorners((GeoCoordinates)newLL, (GeoCoordinates)newUR);
    }

    @Override
    public final RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
        return this.calculateLocRefBoundary(locRef);
    }
}

