/*
 * Decompiled with CFR 0.152.
 */
package openlr.utils.locref.boundary;

import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.RectangleCorners;
import openlr.rawLocRef.RawLocationReference;
import openlr.utils.locref.boundary.BoundingBoxCalculator;

final class PolygonBoundingBoxCalculator
implements BoundingBoxCalculator {
    PolygonBoundingBoxCalculator() {
    }

    @Override
    public RectangleCorners calculateBoundary(RawLocationReference locRef) throws InvalidMapDataException {
        double minLong = Double.MAX_VALUE;
        double minLat = Double.MAX_VALUE;
        double maxLong = Double.MIN_VALUE;
        double maxLat = Double.MIN_VALUE;
        for (GeoCoordinates coord : locRef.getCornerPoints()) {
            if (coord.getLongitudeDeg() < minLong) {
                minLong = coord.getLongitudeDeg();
            } else if (coord.getLongitudeDeg() > maxLong) {
                maxLong = coord.getLongitudeDeg();
            }
            if (coord.getLatitudeDeg() < minLat) {
                minLat = coord.getLatitudeDeg();
                continue;
            }
            if (!(coord.getLatitudeDeg() > maxLat)) continue;
            maxLat = coord.getLatitudeDeg();
        }
        GeoCoordinatesImpl lowerLeft = new GeoCoordinatesImpl(minLong, minLat);
        GeoCoordinatesImpl upperRight = new GeoCoordinatesImpl(maxLong, maxLat);
        return new RectangleCorners((GeoCoordinates)lowerLeft, (GeoCoordinates)upperRight);
    }
}

