/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import openlr.LocationReference;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.StatusCode;
import openlr.encoder.LocationReferenceHolder;
import openlr.rawLocRef.RawLocationReference;

public class LocationReferenceHolderImpl
implements LocationReferenceHolder {
    private final Map<String, LocationReference> data = new HashMap<String, LocationReference>();
    private String id;
    private StatusCode returnCode;
    private final LocationType locType;
    private final RawLocationReference rawData;

    public LocationReferenceHolderImpl(String idString, RawLocationReference rd) {
        this.id = idString;
        this.returnCode = null;
        this.locType = rd.getLocationType();
        this.rawData = rd;
    }

    public LocationReferenceHolderImpl(String idString, StatusCode ex, LocationType lt) {
        this.id = idString;
        this.returnCode = ex;
        this.locType = lt;
        this.rawData = null;
    }

    public final Set<String> getDataFormatIdentifiers() {
        return this.data.keySet();
    }

    public final int getNumberOfDataFormats() {
        return this.data.size();
    }

    public final int getNumberOfValidLR() {
        int valid = 0;
        for (LocationReference lr : this.data.values()) {
            if (!lr.isValid()) continue;
            ++valid;
        }
        return valid;
    }

    public final String getID() {
        return this.id;
    }

    public final boolean isValid() {
        return this.returnCode == null;
    }

    public final StatusCode getReturnCode() {
        return this.returnCode;
    }

    public final int getNrOfLRPs() {
        if (this.rawData == null || this.rawData.getLocationReferencePoints() == null) {
            return 0;
        }
        return this.rawData.getLocationReferencePoints().size();
    }

    public final boolean hasLRPs() {
        if (this.rawData == null || this.rawData.getLocationReferencePoints() == null) {
            return false;
        }
        return !this.rawData.getLocationReferencePoints().isEmpty();
    }

    public final List<LocationReferencePoint> getLRPs() {
        if (this.rawData == null || this.rawData.getLocationReferencePoints() == null) {
            return null;
        }
        return this.rawData.getLocationReferencePoints();
    }

    public final void addLocationReference(String ident, LocationReference lr) {
        this.data.put(ident, lr);
    }

    public final LocationReference getLocationReference(String dataID) {
        return this.data.get(dataID);
    }

    public final LocationType getLocationType() {
        return this.locType;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("id: ").append(this.id);
        sb.append(" loc type: ").append(this.locType);
        if (this.returnCode != null) {
            sb.append(" error: ").append(this.returnCode);
        } else {
            sb.append(" #physformats: ").append(this.data.size());
            Iterator<String> iter = this.data.keySet().iterator();
            while (iter.hasNext()) {
                sb.append(iter.next());
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            sb.append(" #rawData: ").append(this.rawData);
        }
        return sb.toString();
    }

    public final RawLocationReference getRawLocationReferenceData() {
        return this.rawData;
    }
}

