/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import openlr.LocationReference;
import openlr.OpenLRProcessingException;
import openlr.PhysicalEncoder;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.LRDatabase;
import openlr.encoder.LocationReferenceHolder;
import openlr.encoder.LocationReferenceHolderImpl;
import openlr.encoder.OpenLREncoderParameter;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.encoder.worker.CircleEncoder;
import openlr.encoder.worker.ClosedLineEncoder;
import openlr.encoder.worker.GeoCoordEncoder;
import openlr.encoder.worker.GridEncoder;
import openlr.encoder.worker.LineEncoder;
import openlr.encoder.worker.PoiAccessEncoder;
import openlr.encoder.worker.PointAlongEncoder;
import openlr.encoder.worker.PolygonEncoder;
import openlr.encoder.worker.RectangleEncoder;
import openlr.location.Location;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public final class OpenLREncoder
implements openlr.OpenLREncoder {
    private static final Logger LOG = Logger.getLogger(OpenLREncoder.class);
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 4;
    private static final int PATCH_VERSION = 2;

    public List<LocationReferenceHolder> encodeLocations(OpenLREncoderParameter parameter, List<Location> loc) throws OpenLRProcessingException {
        if (loc == null || loc.isEmpty()) {
            LOG.error((Object)"No location provided!");
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INVALID_PARAMETER);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OpenLR encoding of " + loc.size() + " locations started"));
        }
        ArrayList<LocationReferenceHolder> llr = new ArrayList<LocationReferenceHolder>();
        OpenLREncoderProperties properties = new OpenLREncoderProperties(parameter.getConfiguration(), parameter.getPhysicalEncoders());
        for (Location l : loc) {
            LocationReferenceHolder lr = this.encodeLocation(parameter, properties, l);
            llr.add(lr);
        }
        return llr;
    }

    public LocationReferenceHolder encodeLocation(OpenLREncoderParameter parameter, Location loc) throws OpenLRProcessingException {
        return this.encodeLocation(parameter, new OpenLREncoderProperties(parameter.getConfiguration(), parameter.getPhysicalEncoders()), loc);
    }

    private LocationReferenceHolder encodeLocation(OpenLREncoderParameter parameter, OpenLREncoderProperties properties, Location loc) throws OpenLRProcessingException {
        List<PhysicalEncoder> physEncoders;
        if (loc == null) {
            LOG.error((Object)"No location provided!");
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INVALID_PARAMETER);
        }
        int compTime4Cache = properties.getCompTime4Cache();
        long startTime = 0L;
        long endTime = 0L;
        if (parameter.hasLRDatabase()) {
            LRDatabase lrdb = parameter.getLRDatabase();
            LocationReferenceHolder lrh = lrdb.getResult(loc);
            if (LOG.isDebugEnabled() && lrh != null) {
                LOG.debug((Object)"Location found in the database cache");
            }
            if (lrh != null) {
                return lrh;
            }
        }
        if ((physEncoders = parameter.getPhysicalEncoders()).isEmpty()) {
            physEncoders = OpenLREncoder.getPhysicalEncoderServices();
        }
        if (physEncoders.isEmpty()) {
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.NO_PHYSICAL_ENCODER_FOUND);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OpenLR encoder called for ID: " + loc.getID()));
            if (!parameter.hasConfiguration()) {
                LOG.debug((Object)"No configuration available, use default values instead");
            }
        }
        if (parameter.hasMapDatabase() && properties.isCheckTurnRestrictions() && !parameter.getMapDatase().hasTurnRestrictions()) {
            LOG.warn((Object)"Turn restrictions should be checked but there are no turn restrictions loaded!");
        }
        AbstractEncoder worker = null;
        switch (loc.getLocationType()) {
            case GEO_COORDINATES: {
                worker = new GeoCoordEncoder();
                break;
            }
            case LINE_LOCATION: {
                worker = new LineEncoder();
                break;
            }
            case POI_WITH_ACCESS_POINT: {
                worker = new PoiAccessEncoder();
                break;
            }
            case POINT_ALONG_LINE: {
                worker = new PointAlongEncoder();
                break;
            }
            case CIRCLE: {
                worker = new CircleEncoder();
                break;
            }
            case RECTANGLE: {
                worker = new RectangleEncoder();
                break;
            }
            case GRID: {
                worker = new GridEncoder();
                break;
            }
            case POLYGON: {
                worker = new PolygonEncoder();
                break;
            }
            case CLOSED_LINE: {
                worker = new ClosedLineEncoder();
                break;
            }
            default: {
                return new LocationReferenceHolderImpl(loc.getID(), EncoderReturnCode.INVALID_LOCATION_TYPE, loc.getLocationType());
            }
        }
        if (parameter.hasLRDatabase() && compTime4Cache > 0) {
            startTime = System.currentTimeMillis();
        }
        RawLocationReference rawLocRef = worker.doEncoding(loc, properties, parameter.getMapDatase());
        LocationReferenceHolderImpl lrHolder = null;
        if (!rawLocRef.isValid()) {
            lrHolder = new LocationReferenceHolderImpl(rawLocRef.getID(), rawLocRef.getReturnCode(), rawLocRef.getLocationType());
        } else {
            lrHolder = new LocationReferenceHolderImpl(loc.getID(), rawLocRef);
            for (PhysicalEncoder pEnc : physEncoders) {
                int version = properties.getPhysicalFormatVersion(pEnc.getDataFormatIdentifier());
                LocationReference locRef = null;
                locRef = version == -1 ? pEnc.encodeData(rawLocRef) : pEnc.encodeData(rawLocRef, version);
                lrHolder.addLocationReference(pEnc.getDataFormatIdentifier(), locRef);
            }
        }
        if (parameter.hasLRDatabase() && compTime4Cache > 0) {
            endTime = System.currentTimeMillis();
        }
        if (parameter.hasLRDatabase() && (compTime4Cache <= 0 || endTime - startTime > (long)compTime4Cache)) {
            LRDatabase lrdb = parameter.getLRDatabase();
            lrdb.storeResult(loc, (LocationReferenceHolder)lrHolder);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("encoding finished (valid=" + lrHolder.isValid() + ")"));
        }
        return lrHolder;
    }

    public static List<PhysicalEncoder> getPhysicalEncoderServices() {
        ServiceLoader<PhysicalEncoder> encoderServices = ServiceLoader.load(PhysicalEncoder.class);
        ArrayList<PhysicalEncoder> encoders = new ArrayList<PhysicalEncoder>();
        for (PhysicalEncoder p : encoderServices) {
            encoders.add(p);
        }
        return encoders;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 4;
    }

    public int getPatchVersion() {
        return 2;
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(1).append(".").append(4).append(".").append(2);
        return sb.toString();
    }
}

