/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.data;

import java.util.ArrayList;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.location.LocationFactory;
import openlr.map.Line;
import org.apache.log4j.Logger;

public final class AdjustOffsets {
    private static final Logger LOG = Logger.getLogger(AdjustOffsets.class);

    private AdjustOffsets() {
        throw new UnsupportedOperationException();
    }

    public static Location adjustOffsets(Location location, OpenLREncoderProperties properties) throws OpenLREncoderProcessingException {
        int remainingNOff;
        int remainingPOff;
        int posOff = location.getPositiveOffset();
        int negOff = location.getNegativeOffset();
        ArrayList lines = new ArrayList(location.getLocationLines());
        int startLength = ((Line)lines.get(0)).getLineLength();
        int endLength = ((Line)lines.get(lines.size() - 1)).getLineLength();
        if (posOff > startLength) {
            int currLength;
            LOG.warn((Object)"positive offset exceeds length of first line, location will be trimmed");
            for (remainingPOff = posOff; !lines.isEmpty() && ((Line)lines.get(0)).getLineLength() < remainingPOff; remainingPOff -= currLength) {
                currLength = ((Line)lines.get(0)).getLineLength();
                lines.remove(0);
            }
            if (lines.isEmpty()) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
            }
        }
        if (negOff > endLength) {
            int currLength;
            LOG.warn((Object)"negative offset exceeds length of last line, location will be trimmed");
            for (remainingNOff = negOff; !lines.isEmpty() && ((Line)lines.get(lines.size() - 1)).getLineLength() < remainingNOff; remainingNOff -= currLength) {
                currLength = ((Line)lines.get(lines.size() - 1)).getLineLength();
                lines.remove(lines.size() - 1);
            }
            if (lines.isEmpty()) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
            }
        }
        return LocationFactory.createLineLocationWithOffsets((String)location.getID(), lines, (int)remainingPOff, (int)remainingNOff);
    }
}

