/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import openlr.map.Line;
import openlr.map.utils.PathUtils;

public class ExpansionData {
    private static final List<Line> EMPTY_LIST = Collections.emptyList();
    public static final ExpansionData NO_EXPANSION = new ExpansionData(EMPTY_LIST, EMPTY_LIST);
    private List<Line> expansionStart = new ArrayList<Line>();
    private List<Line> expansionEnd = new ArrayList<Line>();
    private int lengthAtStart = 0;
    private int lengthAtEnd = 0;

    public ExpansionData(List<Line> expStart, List<Line> expEnd) {
        this.expansionEnd = expEnd;
        this.expansionStart = expStart;
        this.lengthAtStart = PathUtils.getLength(this.expansionStart);
        this.lengthAtEnd = PathUtils.getLength(this.expansionEnd);
    }

    public final boolean modifyExpansionAtStart(List<Line> toRemove) {
        for (Line l : toRemove) {
            if (this.expansionStart.contains(l)) {
                this.expansionStart.remove(l);
                this.lengthAtStart -= l.getLineLength();
                continue;
            }
            return false;
        }
        return true;
    }

    public final boolean modifyExpansionAtEnd(List<Line> toRemove) {
        for (Line l : toRemove) {
            if (this.expansionEnd.contains(l)) {
                this.expansionEnd.remove(l);
                this.lengthAtEnd -= l.getLineLength();
                continue;
            }
            return false;
        }
        return true;
    }

    public final List<Line> getExpansionStart() {
        return this.expansionStart;
    }

    public final List<Line> getExpansionEnd() {
        return this.expansionEnd;
    }

    public final boolean hasExpansionStart() {
        return !this.expansionStart.isEmpty();
    }

    public final boolean hasExpansionEnd() {
        return !this.expansionEnd.isEmpty();
    }

    public final int getExpansionLengthStart() {
        return this.lengthAtStart;
    }

    public final int getExpansionLengthEnd() {
        return this.lengthAtEnd;
    }

    public final String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(" expansion start: ").append(this.lengthAtStart).append("m [");
        for (i = 0; i < this.expansionStart.size(); ++i) {
            sb.append(this.expansionStart.get(i).getID());
            if (i == this.expansionStart.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        sb.append(" expansion end: ").append(this.lengthAtEnd).append("m [");
        for (i = 0; i < this.expansionEnd.size(); ++i) {
            sb.append(this.expansionEnd.get(i).getID());
            if (i == this.expansionEnd.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

