/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.encoder.data.ExpansionData;
import openlr.encoder.data.LocRefData;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.Node;
import openlr.map.utils.NodeCheck;
import org.apache.log4j.Logger;

public final class ExpansionHelper {
    private static final Logger LOG = Logger.getLogger(ExpansionHelper.class);

    private ExpansionHelper() {
        throw new UnsupportedOperationException();
    }

    public static List<Line> getExpandedLocation(LocRefData locRefData) {
        ExpansionData expansion = locRefData.getExpansionData();
        Location loc = locRefData.getLocation();
        ArrayList<Line> expLocation = new ArrayList<Line>();
        expLocation.addAll(expansion.getExpansionStart());
        LocationType locType = loc.getLocationType();
        if (locType == LocationType.LINE_LOCATION || locType == LocationType.CLOSED_LINE) {
            expLocation.addAll(loc.getLocationLines());
        } else if (locType == LocationType.POI_WITH_ACCESS_POINT || locType == LocationType.POINT_ALONG_LINE) {
            expLocation.add(loc.getPoiLine());
        }
        expLocation.addAll(expansion.getExpansionEnd());
        return expLocation;
    }

    public static ExpansionData createExpandedLocation(OpenLREncoderProperties properties, MapDatabase mdb, LocRefData locRefData) throws OpenLRProcessingException {
        ExpansionData expData = ExpansionData.NO_EXPANSION;
        Location loc = locRefData.getLocation();
        ArrayList<Line> linelist = null;
        LocationType locType = loc.getLocationType();
        int pOff = 0;
        int nOff = 0;
        switch (locType) {
            case LINE_LOCATION: {
                linelist = loc.getLocationLines();
                if (loc.hasPositiveOffset()) {
                    pOff = loc.getPositiveOffset();
                }
                if (loc.hasNegativeOffset()) {
                    nOff = loc.getNegativeOffset();
                }
                expData = ExpansionHelper.doExpansion(mdb, properties, linelist, pOff, nOff);
                break;
            }
            case POI_WITH_ACCESS_POINT: 
            case POINT_ALONG_LINE: {
                ArrayList<Line> temp = new ArrayList<Line>();
                temp.add(loc.getPoiLine());
                linelist = temp;
                if (loc.hasPositiveOffset()) {
                    pOff = loc.getPositiveOffset();
                }
                expData = ExpansionHelper.doExpansion(mdb, properties, linelist, pOff, 0);
                break;
            }
            case CIRCLE: 
            case GEO_COORDINATES: 
            case GRID: 
            case POLYGON: 
            case RECTANGLE: 
            case CLOSED_LINE: {
                break;
            }
            default: {
                LOG.error((Object)"Unknown location type");
            }
        }
        return expData;
    }

    private static ExpansionData doExpansion(MapDatabase mdb, OpenLREncoderProperties properties, List<? extends Line> lineList, int posOff, int negOff) throws OpenLRProcessingException {
        ArrayList<Line> expansionStart = new ArrayList();
        if (!NodeCheck.isValidNode((Node)lineList.get(0).getStartNode())) {
            expansionStart = ExpansionHelper.checkExpansion(lineList, true, posOff, properties);
        }
        ArrayList<Line> expansionDest = new ArrayList();
        if (!NodeCheck.isValidNode((Node)lineList.get(lineList.size() - 1).getEndNode())) {
            expansionDest = ExpansionHelper.checkExpansion(lineList, false, negOff, properties);
        }
        if (properties.isCheckTurnRestrictions() && mdb.hasTurnRestrictions()) {
            ArrayList<Object> path = new ArrayList<Object>();
            path.addAll(expansionStart);
            path.addAll(lineList);
            if (mdb.hasTurnRestrictionOnPath(path)) {
                expansionStart.clear();
            }
            path.clear();
            path.addAll(lineList);
            path.addAll(expansionDest);
            if (mdb.hasTurnRestrictionOnPath(path)) {
                expansionDest.clear();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"expanded location created");
            LOG.debug((Object)("lines added at start: " + expansionStart.size()));
            LOG.debug((Object)("lines added at end: " + expansionDest.size()));
        }
        return new ExpansionData(expansionStart, expansionDest);
    }

    private static List<Line> checkExpansion(List<? extends Line> location, boolean start, int offset, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        Line line = null;
        line = start ? location.get(0) : location.get(location.size() - 1);
        int totalOffset = offset;
        int maxOffset = properties.getMaximumDistanceLRP();
        ArrayList<Line> expansion = new ArrayList<Line>();
        boolean finished = false;
        Iterator candidates = null;
        while (!finished) {
            boolean nodeIsInvalid = true;
            if (start) {
                candidates = line.getPrevLines();
                nodeIsInvalid = !NodeCheck.isValidNode((Node)line.getStartNode());
            } else {
                candidates = line.getNextLines();
                boolean bl = nodeIsInvalid = !NodeCheck.isValidNode((Node)line.getEndNode());
            }
            if (candidates.hasNext() && nodeIsInvalid) {
                Line expline = ExpansionHelper.getExpansion(line, candidates);
                if (expline == null) {
                    finished = true;
                    continue;
                }
                if (location.contains(expline) || expansion.contains(expline)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"expansion would create a loop, stop here!");
                    }
                    finished = true;
                    continue;
                }
                if (totalOffset + expline.getLineLength() > maxOffset) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"expansion would exceed the maxDistance value, stop here!");
                    }
                    finished = true;
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("expansion with line: " + expline.getID()));
                }
                if (start) {
                    expansion.add(0, expline);
                } else {
                    expansion.add(expline);
                }
                line = expline;
                totalOffset += line.getLineLength();
                continue;
            }
            finished = true;
        }
        return expansion;
    }

    private static Line getExpansion(Line l, Iterator<? extends Line> candidates) {
        ArrayList<Line> lines = new ArrayList<Line>();
        while (candidates.hasNext()) {
            lines.add(candidates.next());
        }
        if (lines.size() == 1) {
            return (Line)lines.get(0);
        }
        if (lines.size() == 2) {
            Line l1 = (Line)lines.get(0);
            Line l2 = (Line)lines.get(1);
            boolean pair1 = NodeCheck.isPair((Line)l, (Line)l1);
            boolean pair2 = NodeCheck.isPair((Line)l, (Line)l2);
            if (pair1 && !pair2) {
                return l2;
            }
            if (pair2 && !pair1) {
                return l1;
            }
            if (pair1 && pair2) {
                boolean geom1 = ExpansionHelper.checkLength(l, l1);
                boolean geom2 = ExpansionHelper.checkLength(l, l2);
                if (geom1 && !geom2) {
                    return l2;
                }
                if (geom2 && !geom1) {
                    return l1;
                }
            }
        }
        return null;
    }

    private static boolean checkLength(Line l1, Line l2) {
        int diff = Math.abs(l1.getLineLength() - l2.getLineLength());
        return diff <= 1;
    }
}

