/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.data;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationType;
import openlr.Offsets;
import openlr.encoder.data.ExpansionData;
import openlr.encoder.data.LocRefPoint;
import openlr.encoder.data.OffsetData;
import openlr.location.Location;

public class LocRefData {
    private final Location originalLocation;
    private Location adjustedLocation;
    private ExpansionData expansion = ExpansionData.NO_EXPANSION;
    private List<LocRefPoint> locRefPoints = new ArrayList<LocRefPoint>();
    private int reducedPosOff = 0;
    private int reducedNegOff = 0;

    public LocRefData(Location origin) {
        this.originalLocation = origin;
    }

    public final void setAdjustedLocation(Location loc) {
        this.adjustedLocation = loc;
    }

    public final void setExpansion(ExpansionData eData) {
        this.expansion = eData;
    }

    public final Location getLocation() {
        if (this.adjustedLocation != null) {
            return this.adjustedLocation;
        }
        return this.originalLocation;
    }

    public final Location getOriginalLocation() {
        return this.originalLocation;
    }

    public final ExpansionData getExpansionData() {
        return this.expansion;
    }

    public final void setLocRefPoints(List<LocRefPoint> points) {
        this.locRefPoints.clear();
        this.locRefPoints.addAll(points);
    }

    public final List<LocRefPoint> getLocRefPoints() {
        return new ArrayList<LocRefPoint>(this.locRefPoints);
    }

    public final String getID() {
        return this.originalLocation.getID();
    }

    public final LocationType getLocationType() {
        return this.originalLocation.getLocationType();
    }

    public final void addToReducedPosOff(int value) {
        this.reducedPosOff += value;
    }

    public final void addToReducedNegOff(int value) {
        this.reducedNegOff += value;
    }

    public final Offsets getOffsets() {
        int pOff = this.getLocation().getPositiveOffset() + this.expansion.getExpansionLengthStart() - this.reducedPosOff;
        int nOff = this.getLocation().getNegativeOffset() + this.expansion.getExpansionLengthEnd() - this.reducedNegOff;
        return new OffsetData(pOff, nOff);
    }

    public final int getReducedPosOff() {
        return this.reducedPosOff;
    }

    public final int getReducedNegOff() {
        return this.reducedNegOff;
    }
}

