/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.data;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.OpenLRProcessingException;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.map.GeoCoordinates;
import openlr.map.Line;
import openlr.map.Node;
import openlr.map.utils.GeometryUtils;
import openlr.map.utils.PathUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class LocRefPoint
implements LocationReferencePoint {
    private final Line line;
    private List<Line> subroute;
    private final boolean isPointOnLine;
    private boolean isLast;
    private final double longitude;
    private final double latitude;
    private LocRefPoint next;
    private double bearing;
    private int sequenceNumber;

    public LocRefPoint(List<Line> route, OpenLREncoderProperties p) throws OpenLRProcessingException {
        this.line = route.get(0);
        this.subroute = route;
        this.isPointOnLine = false;
        this.isLast = false;
        this.longitude = this.line.getStartNode().getLongitudeDeg();
        this.latitude = this.line.getStartNode().getLatitudeDeg();
        this.bearing = this.calculateBearing(p);
    }

    public LocRefPoint(List<Line> route, LocRefPoint lrp) throws OpenLRProcessingException {
        this.line = lrp.line;
        this.subroute = route;
        this.isPointOnLine = lrp.isLRPOnLine();
        this.isLast = lrp.isLastLRP();
        this.longitude = lrp.getLongitudeDeg();
        this.latitude = lrp.getLatitudeDeg();
        this.bearing = lrp.getBearing();
        this.next = lrp.next;
        this.sequenceNumber = lrp.getSequenceNumber();
    }

    public LocRefPoint(GeoCoordinates coord) {
        this.line = null;
        this.subroute = null;
        this.isPointOnLine = false;
        this.isLast = false;
        this.longitude = coord.getLongitudeDeg();
        this.latitude = coord.getLatitudeDeg();
        this.bearing = 0.0;
    }

    public final void setNextLRP(LocRefPoint n) {
        this.next = n;
    }

    public LocRefPoint(Line l, OpenLREncoderProperties p) throws OpenLRProcessingException {
        this.line = l;
        this.subroute = null;
        this.isPointOnLine = false;
        this.isLast = true;
        this.longitude = l.getEndNode().getLongitudeDeg();
        this.latitude = l.getEndNode().getLatitudeDeg();
        this.bearing = this.calculateBearing(p);
    }

    public LocRefPoint(Line l, double lon, double lat, OpenLREncoderProperties p, boolean lastLRP) throws OpenLRProcessingException {
        this.line = l;
        this.subroute = new ArrayList<Line>(1);
        this.subroute.add(l);
        this.isPointOnLine = true;
        this.isLast = lastLRP;
        this.longitude = lon;
        this.latitude = lat;
        this.bearing = this.calculateBearing(p);
    }

    public final double getLongitudeDeg() {
        return this.longitude;
    }

    public final double getLatitudeDeg() {
        return this.latitude;
    }

    public final Node getLRPNode() {
        if (this.line == null) {
            throw new UnsupportedOperationException();
        }
        Node n = null;
        if (!this.isPointOnLine) {
            n = !this.isLast ? this.line.getStartNode() : this.line.getEndNode();
        }
        return n;
    }

    public final int getDistanceToNext() {
        int dist = 0;
        if (!this.isLast) {
            dist = this.isPointOnLine ? (this.next != null && this.next.isPointOnLine ? this.next.line.measureAlongLine(this.next.longitude, this.next.latitude) - this.line.measureAlongLine(this.longitude, this.latitude) : this.line.getLineLength() - this.line.measureAlongLine(this.longitude, this.latitude)) : (this.next != null && this.next.isPointOnLine ? (dist += this.next.line.measureAlongLine(this.next.longitude, this.next.latitude)) : PathUtils.getLength(this.subroute));
        }
        return dist;
    }

    public final List<Line> getRoute() {
        return this.subroute;
    }

    public final FunctionalRoadClass getLfrc() {
        if (this.line == null) {
            throw new UnsupportedOperationException();
        }
        FunctionalRoadClass lfrc = null;
        if (this.isPointOnLine) {
            lfrc = this.line.getFRC();
        } else if (this.subroute != null && this.subroute.size() > 0) {
            int frcID = 0;
            for (Line ds : this.subroute) {
                frcID = Math.max(frcID, ds.getFRC().getID());
            }
            return (FunctionalRoadClass)FunctionalRoadClass.getFRCs().get(frcID);
        }
        return lfrc;
    }

    private double calculateBearing(OpenLREncoderProperties properties) throws OpenLRProcessingException {
        GeometryUtils.BearingDirection dir = null;
        dir = !this.isLast ? GeometryUtils.BearingDirection.IN_DIRECTION : GeometryUtils.BearingDirection.AGAINST_DIRECTION;
        int projection = 0;
        if (this.isPointOnLine) {
            projection = this.line.measureAlongLine(this.longitude, this.latitude);
        }
        double b = GeometryUtils.calculateLineBearing((Line)this.line, (GeometryUtils.BearingDirection)dir, (int)properties.getBearingDistance(), (int)projection);
        return b;
    }

    public final FormOfWay getFOW() {
        if (this.line == null) {
            throw new UnsupportedOperationException();
        }
        return this.line.getFOW();
    }

    public final FunctionalRoadClass getFRC() {
        if (this.line == null) {
            throw new UnsupportedOperationException();
        }
        return this.line.getFRC();
    }

    public final boolean isLRPOnLine() {
        return this.isPointOnLine;
    }

    public final boolean isLastLRP() {
        return this.isLast;
    }

    public final double getBearing() {
        return this.bearing;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("line: ").append(this.line.getID());
        sb.append(" lon: ").append(this.longitude);
        sb.append(" lat: ").append(this.latitude);
        sb.append(" bear: ").append(this.bearing);
        sb.append(" isPointOnLine: ").append(this.isPointOnLine);
        sb.append(" isLast: ").append(this.isLast);
        if (this.next != null && this.next.getRoute() != null && !this.next.getRoute().isEmpty()) {
            sb.append(" next lrp line: ").append(this.next.getRoute().get(0).getID());
        }
        if (this.subroute != null && !this.subroute.isEmpty()) {
            sb.append(" [");
            for (int i = 0; i < this.subroute.size(); ++i) {
                sb.append(this.subroute.get(i).getID());
                if (i == this.subroute.size() - 1) continue;
                sb.append(",");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.bearing).append(this.subroute).append((Object)this.line).append((Object)this.next).append(this.isPointOnLine).append(this.isLast).append(this.longitude).append(this.latitude);
        return builder.toHashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof LocRefPoint)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        LocRefPoint other = (LocRefPoint)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.bearing, other.bearing).append(this.subroute, other.subroute).append((Object)this.line, (Object)other.line).append((Object)this.next, (Object)other.next).append(this.isPointOnLine, other.isPointOnLine).append(this.isLast, other.isLast).append(this.longitude, other.longitude).append(this.latitude, other.latitude);
        return builder.isEquals();
    }

    public final int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public final void setSequenceNumber(int seqNr) {
        this.sequenceNumber = seqNr;
    }

    public final Line getLine() {
        return this.line;
    }

    public final Line getLastLineOfSubRoute() {
        if (this.subroute != null) {
            return this.subroute.get(this.subroute.size() - 1);
        }
        return null;
    }
}

