/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.database;

import openlr.encoder.LRDatabase;
import openlr.encoder.LocationReferenceHolder;
import openlr.encoder.database.LRUCache;
import openlr.location.Location;

public class LRDatabaseLRU
implements LRDatabase {
    private final LRUCache<Integer, LocationReferenceHolder> db;

    public LRDatabaseLRU(int cacheSize) {
        this.db = new LRUCache(cacheSize);
    }

    public final boolean containsLR(Location loc) {
        if (loc == null || this.db.isEmpty()) {
            return false;
        }
        return this.db.containsKey(loc.hashCode());
    }

    public final void storeResult(Location loc, LocationReferenceHolder locref) {
        if (loc == null || locref == null) {
            return;
        }
        int key = loc.hashCode();
        this.db.put(key, locref);
    }

    public final LocationReferenceHolder getResult(Location loc) {
        if (loc == null) {
            throw new IllegalArgumentException();
        }
        int key1 = loc.hashCode();
        return this.db.get(key1);
    }

    public final int getCacheSize() {
        return this.db.getMaximumSize();
    }

    public final int getCurrentNrEntries() {
        return this.db.size();
    }

    public final void clear() {
        this.db.clear();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("max size: ").append(this.getCacheSize());
        sb.append(" #entries: ").append(this.getCurrentNrEntries());
        return sb.toString();
    }
}

