/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locRefAdjust;

import java.util.ArrayList;
import java.util.List;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.data.ExpansionData;
import openlr.encoder.data.ExpansionHelper;
import openlr.encoder.data.LocRefData;
import openlr.encoder.data.LocRefPoint;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.Node;
import openlr.map.utils.NodeCheck;
import openlr.map.utils.PathUtils;
import org.apache.log4j.Logger;

public abstract class LocationReferenceAdjust {
    private static final Logger LOG = Logger.getLogger(LocationReferenceAdjust.class);

    public abstract void adjustLocationReference(OpenLREncoderProperties var1, LocRefData var2) throws OpenLRProcessingException;

    protected final List<LocRefPoint> checkAndAdjustOffsets(LocRefData lrd, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        List<LocRefPoint> checkedAndAdjusted = lrd.getLocRefPoints();
        Location location = lrd.getLocation();
        ExpansionData expansion = lrd.getExpansionData();
        int startLength = checkedAndAdjusted.get(0).getDistanceToNext();
        int totalPosOff = location.getPositiveOffset() + expansion.getExpansionLengthStart();
        while (totalPosOff > startLength) {
            if (expansion.hasExpansionStart()) {
                if (!expansion.modifyExpansionAtStart(checkedAndAdjusted.get(0).getRoute())) {
                    throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
                }
            } else {
                lrd.addToReducedPosOff(startLength);
            }
            checkedAndAdjusted.remove(0);
            if (checkedAndAdjusted.size() < 2) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
            }
            startLength = checkedAndAdjusted.get(0).getDistanceToNext();
            totalPosOff = location.getPositiveOffset() + expansion.getExpansionLengthStart() - lrd.getReducedPosOff();
        }
        int endLength = checkedAndAdjusted.get(checkedAndAdjusted.size() - 2).getDistanceToNext();
        int totalNegOff = location.getNegativeOffset() + expansion.getExpansionLengthEnd();
        while (totalNegOff > endLength) {
            if (expansion.hasExpansionEnd()) {
                if (!expansion.modifyExpansionAtEnd(checkedAndAdjusted.get(checkedAndAdjusted.size() - 2).getRoute())) {
                    throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
                }
            } else {
                lrd.addToReducedNegOff(endLength);
            }
            checkedAndAdjusted.remove(checkedAndAdjusted.size() - 1);
            if (checkedAndAdjusted.size() < 2) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.OFFSET_TRIMMING_FAILED);
            }
            LocRefPoint oldLastLRP = checkedAndAdjusted.get(checkedAndAdjusted.size() - 1);
            LocRefPoint prevLRP = checkedAndAdjusted.get(checkedAndAdjusted.size() - 2);
            LocRefPoint newLastLRP = oldLastLRP.isLRPOnLine() ? new LocRefPoint(oldLastLRP.getLine(), oldLastLRP.getLongitudeDeg(), oldLastLRP.getLatitudeDeg(), properties, true) : new LocRefPoint(prevLRP.getLastLineOfSubRoute(), properties);
            checkedAndAdjusted.remove(checkedAndAdjusted.size() - 1);
            prevLRP.setNextLRP(newLastLRP);
            checkedAndAdjusted.add(newLastLRP);
            endLength = checkedAndAdjusted.get(checkedAndAdjusted.size() - 2).getDistanceToNext();
            totalNegOff = location.getNegativeOffset() + expansion.getExpansionLengthEnd() - lrd.getReducedNegOff();
        }
        return checkedAndAdjusted;
    }

    protected final List<LocRefPoint> fit4PointLocation(LocRefData locRefData, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        Location location = locRefData.getLocation();
        ArrayList<LocRefPoint> reducedLRPs = new ArrayList<LocRefPoint>();
        Line pLine = location.getPoiLine();
        List<LocRefPoint> points = locRefData.getLocRefPoints();
        for (int i = 0; i < points.size() - 1; ++i) {
            LocRefPoint l = points.get(i);
            if (l.getRoute() == null || !l.getRoute().contains(pLine)) continue;
            reducedLRPs.add(l);
            LocRefPoint prevLast = points.get(i + 1);
            LocRefPoint newLast = new LocRefPoint(prevLast.getLastLineOfSubRoute(), properties);
            reducedLRPs.add(newLast);
            break;
        }
        return reducedLRPs;
    }

    protected final void checkNodeValidity(List<LocRefPoint> locRefPoints) {
        int total = locRefPoints.size();
        for (int i = 0; i < total; ++i) {
            LocRefPoint lrp = locRefPoints.get(i);
            Node lrpNode = lrp.getLRPNode();
            if (NodeCheck.isValidNode((Node)lrpNode)) continue;
            LOG.warn((Object)("location reference point (" + (i + 1) + " is located on an invalid node)"));
        }
    }

    protected final void checkMaxDistances(OpenLREncoderProperties properties, LocRefData locRefData) throws OpenLRProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"check location reference (maximum distance check)");
        }
        List<LocRefPoint> locRefPoints = locRefData.getLocRefPoints();
        int maxDistance = properties.getMaximumDistanceLRP();
        for (LocRefPoint lrPoint : locRefPoints) {
            if (lrPoint.isLastLRP() || lrPoint.getDistanceToNext() <= maxDistance) continue;
            LOG.error((Object)("maximum distance between two LRP is exceeded (distance is: " + lrPoint.getDistanceToNext() + ")"));
        }
    }

    protected final boolean checkLRPCoverage(LocRefData locRefData) {
        List<LocRefPoint> locRefPoints = locRefData.getLocRefPoints();
        List<Line> locRoute = ExpansionHelper.getExpandedLocation(locRefData);
        int lrpLength = 0;
        ArrayList<Line> lrpRoute = new ArrayList<Line>();
        for (LocRefPoint lrd : locRefPoints) {
            List<Line> route;
            if (lrd.getRoute() == null) continue;
            if (!lrd.isLRPOnLine()) {
                if (locRefData.getLocationType() == LocationType.CLOSED_LINE && lrd == locRefPoints.get(locRefPoints.size() - 1)) {
                    route = lrd.getRoute();
                    route.add(locRefPoints.get(0).getRoute().get(0));
                    lrpRoute.addAll(route);
                    route.remove(route.size() - 1);
                } else {
                    lrpRoute.addAll(lrd.getRoute());
                }
            }
            if (locRefData.getLocationType() == LocationType.CLOSED_LINE && lrd == locRefPoints.get(locRefPoints.size() - 1)) {
                route = lrd.getRoute();
                route.add(locRefPoints.get(0).getRoute().get(0));
                lrpLength += PathUtils.getLength(route);
                route.remove(route.size() - 1);
                continue;
            }
            lrpLength += lrd.getDistanceToNext();
        }
        if (locRoute.size() != lrpRoute.size()) {
            LOG.error((Object)"number of lines are different");
            LOG.error((Object)("location: " + locRoute.size() + " - locRef: " + lrpRoute.size()));
            return false;
        }
        int locationLength = 0;
        int count = locRoute.size();
        for (int i = 0; i < count; ++i) {
            Line next = locRoute.get(i);
            if (next.getID() != ((Line)lrpRoute.get(i)).getID()) {
                LOG.error((Object)"paths are different");
                LOG.error((Object)("location line: " + next.getID() + " - locRef line: " + ((Line)lrpRoute.get(i)).getID()));
                return false;
            }
            locationLength += next.getLineLength();
        }
        if (locationLength != lrpLength) {
            LOG.error((Object)"lengths are different");
            LOG.error((Object)("location: " + locationLength + " - locRef: " + lrpLength));
            return false;
        }
        return true;
    }
}

