/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locRefAdjust.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.data.LocRefData;
import openlr.encoder.locRefAdjust.LocationReferenceAdjust;
import openlr.encoder.properties.OpenLREncoderProperties;
import org.apache.log4j.Logger;

public class PointAlongLocRefAdjust
extends LocationReferenceAdjust {
    private static final Logger LOG = Logger.getLogger(PointAlongLocRefAdjust.class);

    @Override
    public final void adjustLocationReference(OpenLREncoderProperties properties, LocRefData locRefData) throws OpenLRProcessingException {
        this.checkMaxDistances(properties, locRefData);
        if (!this.checkLRPCoverage(locRefData)) {
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.LOCATION_REFERENCE_DOES_NOT_COVER_LOCATION);
        }
        locRefData.setLocRefPoints(this.checkAndAdjustOffsets(locRefData, properties));
        if (locRefData.getLocRefPoints().size() != 2) {
            locRefData.setLocRefPoints(this.fit4PointLocation(locRefData, properties));
            if (locRefData.getLocRefPoints().isEmpty()) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INVALID_POINT_LOCATION_LRP);
            }
        }
        if (LOG.isDebugEnabled()) {
            this.checkNodeValidity(locRefData.getLocRefPoints());
        }
    }
}

