/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.IteratorHelper;
import org.apache.log4j.Logger;

public abstract class LocationCheck {
    private static final Logger LOG = Logger.getLogger(LocationCheck.class);
    private static final float MAX_LAT = 90.0f;
    private static final float MIN_LAT = -90.0f;
    private static final float MAX_LON = 180.0f;
    private static final float MIN_LON = -180.0f;

    public abstract CheckResult check(OpenLREncoderProperties var1, MapDatabase var2, Location var3) throws OpenLRProcessingException;

    public abstract CheckResult checkOffsets(OpenLREncoderProperties var1, Location var2) throws OpenLRProcessingException;

    protected final boolean checkCoordinateBounds(double x, double y) {
        return x >= -180.0 && x <= 180.0 && y >= -90.0 && y <= 90.0;
    }

    protected final boolean checkTurnRestrictions(MapDatabase mapDB, Location location) {
        if (!mapDB.hasTurnRestrictions()) {
            return true;
        }
        return mapDB.hasTurnRestrictionOnPath(location.getLocationLines());
    }

    protected final boolean checkTurnRestrictionClosedLine(MapDatabase mapDB, List<? extends Line> lines) {
        if (!mapDB.hasTurnRestrictions()) {
            return true;
        }
        ArrayList<? extends Line> theLines = new ArrayList<Line>(lines);
        theLines.add((Line)theLines.get(0));
        return mapDB.hasTurnRestrictionOnPath(theLines);
    }

    protected final boolean checkLocationConnection(List<? extends Line> lines) {
        int size = lines.size();
        String error = null;
        if (size == 1 && lines.get(0) == null) {
            error = "location contains only a null entry in lines list";
        }
        for (int i = 0; i < size - 1; ++i) {
            Line currentLine = lines.get(i);
            Line successorLine = lines.get(i + 1);
            if (currentLine == null || successorLine == null) {
                error = "location contains null entries in lines list";
                break;
            }
            Iterator succLines = currentLine.getNextLines();
            if (IteratorHelper.contains((Iterator)succLines, (Object)successorLine)) continue;
            error = "location not connected from " + currentLine.getID() + " to " + successorLine.getID();
            break;
        }
        if (error != null) {
            LOG.error((Object)error);
            return false;
        }
        return true;
    }

    protected final boolean isPathClosed(List<? extends Line> lines) {
        int size = lines.size();
        Line firstLine = lines.get(0);
        Line lastLine = lines.get(size - 1);
        if (firstLine == null || lastLine == null) {
            LOG.error((Object)"location contains null entries in lines list");
            return false;
        }
        Iterator succLines = lastLine.getNextLines();
        if (!IteratorHelper.contains((Iterator)succLines, (Object)firstLine)) {
            LOG.error((Object)("unclosed closed location, not connected from " + lastLine.getID() + " to " + firstLine.getID()));
            return false;
        }
        return true;
    }
}

