/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class CircleLocationCheck
extends LocationCheck {
    private static final long MAX_RADIUS = (long)Math.pow(2.0, 32.0);
    private static final Logger LOG = Logger.getLogger(CircleLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) {
        if (location.getRadius() <= 0L) {
            LOG.error((Object)"invalid radius");
            return new CheckResult(EncoderReturnCode.INVALID_RADIUS);
        }
        if (location.getRadius() > MAX_RADIUS) {
            LOG.error((Object)"invalid radius");
            return new CheckResult(EncoderReturnCode.INVALID_RADIUS);
        }
        if (!this.checkCoordinateBounds(location.getCenterPoint().getLongitudeDeg(), location.getCenterPoint().getLatitudeDeg())) {
            LOG.error((Object)"invalid center coordinates");
            return new CheckResult(EncoderReturnCode.COORDINATES_OUT_OF_BOUNDS);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        return CheckResult.PASSED;
    }
}

