/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.LineLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class ClosedLineLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(LineLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) throws OpenLRProcessingException {
        if (mapDB == null) {
            LOG.error((Object)"map database is empty");
            return new CheckResult(EncoderReturnCode.MAP_DATABASE_IS_EMPTY);
        }
        if (location.getLocationLines() == null || location.getLocationLines().isEmpty()) {
            LOG.error((Object)"location is empty");
            return new CheckResult(EncoderReturnCode.LOCATION_IS_EMPTY);
        }
        if (!this.checkLocationConnection(location.getLocationLines())) {
            LOG.error((Object)("location " + location.getID() + " is not connected"));
            return new CheckResult(EncoderReturnCode.LOCATION_NOT_CONNECTED);
        }
        if (!this.isPathClosed(location.getLocationLines())) {
            LOG.error((Object)("location " + location.getID() + " is not connected"));
            return new CheckResult(EncoderReturnCode.LOCATION_NOT_CONNECTED);
        }
        if (properties.isCheckTurnRestrictions() && this.checkTurnRestrictionClosedLine(mapDB, location.getLocationLines())) {
            LOG.error((Object)("turn restriction conflict (" + location.getID() + ")"));
            return new CheckResult(EncoderReturnCode.LOCATION_CONTAINS_TURN_RESTRICTION);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        return CheckResult.PASSED;
    }
}

