/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class GeoCoordinateLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(GeoCoordinateLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) {
        if (!this.checkCoordinateBounds(location.getPointLocation().getLongitudeDeg(), location.getPointLocation().getLatitudeDeg())) {
            LOG.error((Object)"invalid coordinates");
            return new CheckResult(EncoderReturnCode.COORDINATES_OUT_OF_BOUNDS);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        return CheckResult.PASSED;
    }
}

