/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.GeoCoordinates;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class GridLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(GridLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) {
        if (location.getNumberOfColumns() <= 0 || location.getNumberOfColumns() > Short.MAX_VALUE) {
            LOG.error((Object)"invalid number of columns");
            return new CheckResult(EncoderReturnCode.INVALID_NUMBER_OF_COLUMNS);
        }
        if (location.getNumberOfRows() <= 0 || location.getNumberOfRows() > Short.MAX_VALUE) {
            LOG.error((Object)"invalid number of rows");
            return new CheckResult(EncoderReturnCode.INVALID_NUMBER_OF_ROWS);
        }
        if (location.getCornerPoints() == null) {
            LOG.error((Object)"corner points are missing");
            return new CheckResult(EncoderReturnCode.MISSING_CORNERS);
        }
        for (GeoCoordinates corner : location.getCornerPoints()) {
            if (this.checkCoordinateBounds(corner.getLongitudeDeg(), corner.getLatitudeDeg())) continue;
            LOG.error((Object)"invalid coordinates");
            return new CheckResult(EncoderReturnCode.COORDINATES_OUT_OF_BOUNDS);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        return CheckResult.PASSED;
    }
}

