/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class LineLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(LineLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) throws OpenLRProcessingException {
        if (mapDB == null) {
            LOG.error((Object)"map database is empty");
            return new CheckResult(EncoderReturnCode.MAP_DATABASE_IS_EMPTY);
        }
        if (location.getLocationLines() == null || location.getLocationLines().isEmpty()) {
            LOG.error((Object)"location is empty");
            return new CheckResult(EncoderReturnCode.LOCATION_IS_EMPTY);
        }
        if (!this.checkLocationConnection(location.getLocationLines())) {
            LOG.error((Object)("location " + location.getID() + " is not connected"));
            return new CheckResult(EncoderReturnCode.LOCATION_NOT_CONNECTED);
        }
        if (properties.isCheckTurnRestrictions() && this.checkTurnRestrictions(mapDB, location)) {
            LOG.error((Object)("turn restriction conflict (" + location.getID() + ")"));
            return new CheckResult(EncoderReturnCode.LOCATION_CONTAINS_TURN_RESTRICTION);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        if (location.getLocationLines() == null || location.getLocationLines().isEmpty()) {
            LOG.error((Object)"location is empty");
            return new CheckResult(EncoderReturnCode.LOCATION_IS_EMPTY);
        }
        return this.checkLocationOffsets(location, properties);
    }

    private CheckResult checkLocationOffsets(Location location, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        int posOff = location.getPositiveOffset();
        int negOff = location.getNegativeOffset();
        List lines = location.getLocationLines();
        int totalLength = 0;
        for (Line l : lines) {
            totalLength += l.getLineLength();
        }
        if (posOff + negOff > totalLength) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"offsets are longer than the location");
            }
            return new CheckResult(EncoderReturnCode.OFFSET_FAILURE);
        }
        int maxDistance = properties.getMaximumDistanceLRP();
        if (posOff > maxDistance) {
            LOG.warn((Object)"positive offset exceeds maximum distance, a physical format may not support this");
        }
        if (negOff > maxDistance) {
            LOG.warn((Object)"negative offset exceeds maximum distance, a physical format may not support this");
        }
        return CheckResult.PASSED;
    }
}

