/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.Line;
import openlr.map.MapDatabase;
import org.apache.log4j.Logger;

public class PointAlongLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(PointAlongLocationCheck.class);

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) {
        if (mapDB == null) {
            LOG.error((Object)"map database is empty");
            return new CheckResult(EncoderReturnCode.MAP_DATABASE_IS_EMPTY);
        }
        Line l = location.getPoiLine();
        if (l == null) {
            LOG.error((Object)"no line found");
            return new CheckResult(EncoderReturnCode.NO_LINE_FOR_POINT_LOCATION);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        Line l = location.getPoiLine();
        if (l == null) {
            LOG.error((Object)"no line found");
            return new CheckResult(EncoderReturnCode.NO_LINE_FOR_POINT_LOCATION);
        }
        int offsetValue = location.getPositiveOffset();
        if (offsetValue > l.getLineLength()) {
            LOG.error((Object)"offsets are longer than line");
            return new CheckResult(EncoderReturnCode.OFFSET_LINE_MISMATCH);
        }
        return CheckResult.PASSED;
    }
}

