/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.locationCheck.worker;

import java.awt.geom.Line2D;
import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.encoder.EncoderReturnCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.location.Location;
import openlr.map.GeoCoordinates;
import openlr.map.MapDatabase;
import openlr.map.utils.GeometryUtils;
import org.apache.log4j.Logger;

public class PolygonLocationCheck
extends LocationCheck {
    private static final Logger LOG = Logger.getLogger(PolygonLocationCheck.class);
    private static final int MIN_NR_COORDINATES = 3;

    @Override
    public final CheckResult check(OpenLREncoderProperties properties, MapDatabase mapDB, Location location) {
        List points = location.getCornerPoints();
        if (points == null) {
            LOG.error((Object)"corner points are missing");
            return new CheckResult(EncoderReturnCode.MISSING_CORNERS);
        }
        if (points.size() < 3) {
            LOG.error((Object)"not enough corner points");
            return new CheckResult(EncoderReturnCode.MISSING_CORNERS);
        }
        for (GeoCoordinates corner : points) {
            if (this.checkCoordinateBounds(corner.getLongitudeDeg(), corner.getLatitudeDeg())) continue;
            LOG.error((Object)"invalid coordinates");
            return new CheckResult(EncoderReturnCode.COORDINATES_OUT_OF_BOUNDS);
        }
        if (!PolygonLocationCheck.isIntersectionFree(points)) {
            LOG.error((Object)"the polygon is not simple");
            return new CheckResult(EncoderReturnCode.POLYGON_NOT_SIMPLE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"location check passed");
        }
        return CheckResult.PASSED;
    }

    private static boolean isIntersectionFree(List<? extends GeoCoordinates> points) {
        int nrCoord = points.size();
        for (int i = 0; i < nrCoord - 2; ++i) {
            GeoCoordinates lineStart = points.get(i);
            GeoCoordinates lineEnd = points.get(i + 1);
            for (int j = i + 1; j < nrCoord - 1; ++j) {
                Line2D.Double line1;
                GeoCoordinates nextLineStart = points.get(j);
                GeoCoordinates nextLineEnd = points.get(j + 1);
                if (!(j == i + 1 ? (line1 = new Line2D.Double(lineStart.getLongitudeDeg(), lineStart.getLatitudeDeg(), lineEnd.getLongitudeDeg(), lineEnd.getLatitudeDeg())).contains(nextLineEnd.getLongitudeDeg(), nextLineEnd.getLatitudeDeg()) : GeometryUtils.lineIntersection((GeoCoordinates)lineStart, (GeoCoordinates)lineEnd, (GeoCoordinates)nextLineStart, (GeoCoordinates)nextLineEnd))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final CheckResult checkOffsets(OpenLREncoderProperties properties, Location location) throws OpenLRProcessingException {
        return CheckResult.PASSED;
    }
}

