/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.properties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import openlr.OpenLRProcessingException;
import openlr.PhysicalEncoder;
import openlr.encoder.properties.OpenLREncoderProperty;
import openlr.properties.OpenLRProperty;
import openlr.properties.OpenLRPropertyAccess;
import org.apache.commons.configuration.Configuration;

public class OpenLREncoderProperties {
    private final int bearingDistance;
    private final int maximumDistanceLRP;
    private final boolean checkTurnRestrictions;
    private final Map<String, Integer> physicalFormatVersion;
    private final int compTime4Cache;

    public OpenLREncoderProperties(Configuration config, List<PhysicalEncoder> physEncoders) throws OpenLRProcessingException {
        this.bearingDistance = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLREncoderProperty.BEAR_DIST);
        this.maximumDistanceLRP = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLREncoderProperty.MAX_DIST_LRP);
        this.checkTurnRestrictions = OpenLRPropertyAccess.getBooleanPropertyValue((Configuration)config, (OpenLRProperty)OpenLREncoderProperty.TURN_RESTRICTION_CHECK);
        this.physicalFormatVersion = new HashMap<String, Integer>();
        for (PhysicalEncoder pEnc : physEncoders) {
            String id = pEnc.getDataFormatIdentifier();
            int version = OpenLRPropertyAccess.getIntegerPropertyValueById((Configuration)config, (OpenLRProperty)OpenLREncoderProperty.PHYSICAL_FORMAT_VERSION, (String)id);
            this.physicalFormatVersion.put(id, version);
        }
        this.compTime4Cache = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLREncoderProperty.COMP_TIME_4_CACHE);
    }

    public final int getBearingDistance() {
        return this.bearingDistance;
    }

    public final int getMaximumDistanceLRP() {
        return this.maximumDistanceLRP;
    }

    public final boolean isCheckTurnRestrictions() {
        return this.checkTurnRestrictions;
    }

    public final int getPhysicalFormatVersion(String id) {
        if (this.physicalFormatVersion.containsKey(id)) {
            return this.physicalFormatVersion.get(id);
        }
        return -1;
    }

    public final int getCompTime4Cache() {
        return this.compTime4Cache;
    }
}

