/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.routesearch;

import java.util.List;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.routesearch.RouteSearchData;
import openlr.encoder.routesearch.RouteSearchResult;
import openlr.map.Line;
import openlr.map.Node;
import openlr.map.utils.LineLinkedListElement;
import openlr.map.utils.NodeCheck;
import openlr.map.utils.PQElem;
import openlr.map.utils.PathUtils;
import org.apache.log4j.Logger;

public class IntermediateHandler {
    private static final Logger LOG = Logger.getLogger(IntermediateHandler.class);
    private PQElem lastElemOnLocation;
    private int lastElemPos;
    private final List<? extends Line> location;

    IntermediateHandler(List<? extends Line> loc) {
        this.location = loc;
        this.lastElemOnLocation = null;
        this.lastElemPos = -1;
    }

    public final RouteSearchResult checkIntermediate(PQElem actualElement, RouteSearchData data) throws OpenLREncoderProcessingException {
        RouteSearchResult result = null;
        if (this.lastElemOnLocation == null) {
            this.lastElemOnLocation = actualElement;
            this.lastElemPos = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("first line in sub route found: " + actualElement.getLine().getID()));
            }
        } else if (this.isNextElementInLocation(actualElement)) {
            ++this.lastElemPos;
            this.lastElemOnLocation = actualElement;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("next line in sub route found: " + actualElement.getLine().getID()));
            }
        } else {
            Line deviationStart = PathUtils.findCommonLineInPaths(this.location, (LineLinkedListElement)actualElement.getPrevious());
            if (deviationStart == null) {
                LOG.error((Object)"no start of deviation found");
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
            }
            if (deviationStart.getID() == this.lastElemOnLocation.getLine().getID()) {
                Line intermediate = this.location.get(this.lastElemPos + 1);
                PQElem intermediateElement = (PQElem)PathUtils.findElementInQueue(data.getOpenList(), (Line)intermediate);
                if (intermediateElement == null) {
                    LOG.error((Object)"intermediate not found in open list");
                    throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
                }
                PQElem pIntermediate = intermediateElement.getPrevious();
                if (pIntermediate == null) {
                    LOG.error((Object)"no predecessor of intermediate element found");
                    throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
                }
                List route = PathUtils.constructPath((LineLinkedListElement)this.lastElemOnLocation);
                if (pIntermediate.getLine().getID() == this.lastElemOnLocation.getLine().getID()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"one intermediate found: one deviation at current element detected");
                    }
                    result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, route, intermediate, this.location.indexOf(intermediate));
                } else {
                    PQElem secondIntermediate = this.findValidIntermediateAlongCurrentPath();
                    if (secondIntermediate == null) {
                        LOG.error((Object)"cannot determine second intermediate position");
                        throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"second intermediate found");
                    }
                    result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, route, intermediate, this.location.indexOf(intermediate), secondIntermediate.getLine());
                }
            } else {
                PQElem intermediateElem = this.findValidIntermediateAlongCurrentPath();
                if (intermediateElem == null) {
                    LOG.error((Object)"cannot determine intermediate for deviation");
                    throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"one intermediate found: one deviation at previous element detected");
                }
                List route = PathUtils.constructPath((LineLinkedListElement)intermediateElem.getPrevious());
                result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, route, intermediateElem.getLine(), this.location.indexOf(intermediateElem.getLine()));
            }
        }
        return result;
    }

    private boolean isNextElementInLocation(PQElem actualElement) {
        long lastLocLineID = this.lastElemOnLocation.getLine().getID();
        long actPrevLineID = actualElement.getPrevious().getLine().getID();
        long nextLocLineID = this.location.get(this.lastElemPos + 1).getID();
        long actLineID = actualElement.getLine().getID();
        boolean equalPrev = lastLocLineID == actPrevLineID;
        boolean nextInLocation = nextLocLineID == actLineID;
        return equalPrev && nextInLocation;
    }

    private PQElem findValidIntermediateAlongCurrentPath() {
        if (this.location.isEmpty() || this.lastElemOnLocation == null) {
            return null;
        }
        long startLineID = this.location.get(0).getID();
        boolean ready = false;
        PQElem currentElem = this.lastElemOnLocation;
        PQElem retValue = null;
        while (!ready) {
            if (currentElem.getLine().getID() == startLineID) {
                retValue = this.lastElemOnLocation;
                ready = true;
                continue;
            }
            if (NodeCheck.isValidNode((Node)currentElem.getLine().getStartNode())) {
                ready = true;
                retValue = currentElem;
                continue;
            }
            if ((currentElem = currentElem.getPrevious()) != null) continue;
            ready = true;
        }
        return retValue;
    }

    public final int getLastElemOnRoutePos() {
        return this.lastElemPos;
    }
}

