/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.routesearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import openlr.collection.OpenLongHashSet;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.routesearch.IntermediateHandler;
import openlr.encoder.routesearch.RouteSearchData;
import openlr.encoder.routesearch.RouteSearchResult;
import openlr.map.FunctionalRoadClass;
import openlr.map.Line;
import openlr.map.Node;
import openlr.map.utils.GeometryUtils;
import openlr.map.utils.LineLinkedListElement;
import openlr.map.utils.PQElem;
import openlr.map.utils.PathUtils;
import org.apache.log4j.Logger;

public class RouteSearch {
    private static final FunctionalRoadClass.FrcComparator FRC_COMPARATOR = new FunctionalRoadClass.FrcComparator();
    private static final Logger LOG = Logger.getLogger(RouteSearch.class);
    private double destX = 0.0;
    private double destY = 0.0;
    private final List<? extends Line> location;
    private final Line startLine;
    private final Line destLine;
    private final int startLoopIndex;
    private final int endLoopIndex;

    public RouteSearch(List<? extends Line> loc) throws OpenLREncoderProcessingException {
        this.location = loc;
        if (this.location == null || this.location.isEmpty()) {
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.ROUTE_CONSTRUCTION_ERROR);
        }
        this.startLine = this.location.get(0);
        this.destLine = this.location.get(this.location.size() - 1);
        this.startLoopIndex = this.checkLoopAtStart();
        this.endLoopIndex = this.checkLoopAtEnd();
    }

    private int checkLoopAtStart() {
        int index = this.location.subList(1, this.location.size()).indexOf(this.startLine);
        if (index > 0) {
            int totalLoops = Collections.frequency(this.location, this.startLine);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"loop detected");
                LOG.debug((Object)("total occurences of start line: " + totalLoops));
            }
        }
        return index;
    }

    private int checkLoopAtEnd() {
        int firstEndLineIndex = this.location.indexOf(this.destLine);
        int index = -1;
        if (firstEndLineIndex < this.location.size() - 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"end loop detected");
            }
            index = firstEndLineIndex;
        }
        return index;
    }

    public final RouteSearchResult calculateRoute(FunctionalRoadClass lfrc) throws OpenLREncoderProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("route search between start (" + this.startLine.getID() + ") and dest (" + this.destLine.getID() + ")"));
        }
        RouteSearchResult result = null;
        if (this.startLine.getID() == this.destLine.getID() && this.location.size() > 1) {
            ArrayList<Line> route = new ArrayList<Line>(1);
            route.add(this.startLine);
            result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, route, this.location.get(1), 1);
        } else if (this.startLoopIndex == 0) {
            ArrayList<Line> route = new ArrayList<Line>();
            route.add(this.startLine);
            result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, route, this.location.get(1), 1);
        } else {
            PQElem actualElement;
            IntermediateHandler iHandler = new IntermediateHandler(this.location);
            RouteSearchData data = new RouteSearchData();
            Node e = this.destLine.getEndNode();
            this.destX = e.getLongitudeDeg();
            this.destY = e.getLatitudeDeg();
            int startLength = this.startLine.getLineLength();
            PQElem startElem = new PQElem(this.startLine, 0, startLength, null);
            data.addToOpen(startElem);
            OpenLongHashSet locationIDs = new OpenLongHashSet(this.location.size());
            for (Line line : this.location) {
                locationIDs.put(line.getID());
            }
            while (!(data.isOpenEmpty() || locationIDs.containsKey((actualElement = data.pollElement()).getLine().getID()) && (result = iHandler.checkIntermediate(actualElement, data)) != null)) {
                if (actualElement.getLine().getID() == this.destLine.getID()) {
                    if (this.endLoopIndex >= 0) {
                        List list = PathUtils.constructPath((LineLinkedListElement)actualElement.getPrevious());
                        result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, list, this.destLine, this.endLoopIndex);
                        break;
                    }
                    List list = PathUtils.constructPath((LineLinkedListElement)actualElement);
                    if (list.isEmpty()) {
                        throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.ROUTE_CONSTRUCTION_ERROR);
                    }
                    result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.ROUTE_FOUND, list);
                    break;
                }
                if (this.startLoopIndex > 0 && iHandler.getLastElemOnRoutePos() == this.startLoopIndex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"loop is traversed, intermediate found");
                    }
                    List list = PathUtils.constructPath((LineLinkedListElement)actualElement.getPrevious());
                    result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.INTERMEDIATE_FOUND, list, this.startLine, this.startLoopIndex);
                    break;
                }
                this.extractNextLines(actualElement, data, lfrc);
            }
            if (result == null) {
                result = new RouteSearchResult(RouteSearchResult.RouteSearchReturnCode.NO_ROUTE_FOUND);
            }
        }
        return result;
    }

    private void extractNextLines(PQElem actualElement, RouteSearchData data, FunctionalRoadClass lfrc) {
        Iterator iterNext = actualElement.getLine().getNextLines();
        while (iterNext.hasNext()) {
            PQElem newElem;
            Line succ = (Line)iterNext.next();
            if (FRC_COMPARATOR.compare(succ.getFRC(), lfrc) < 0) continue;
            Node succEnd = succ.getEndNode();
            int heurist = (int)Math.round(GeometryUtils.distance((double)this.destX, (double)this.destY, (double)succEnd.getLongitudeDeg(), (double)succEnd.getLatitudeDeg()));
            int newDist = actualElement.getSecondVal() + succ.getLineLength();
            int newHeurVal = newDist + heurist;
            if (data.hasLengthValue(succ)) {
                if (newDist >= data.getLengthValue(succ)) continue;
                newElem = new PQElem(succ, newHeurVal, newDist, actualElement);
                data.updateInOpen(newElem);
                continue;
            }
            newElem = new PQElem(succ, newHeurVal, newDist, actualElement);
            data.addToOpen(newElem);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" destination lon: ").append(this.destX);
        sb.append(" destination lat: ").append(this.destY);
        if (this.startLoopIndex > 0) {
            sb.append(" start loop found at: ").append(this.startLoopIndex);
        }
        if (this.endLoopIndex > 0) {
            sb.append(" end loop found at: ").append(this.endLoopIndex);
        }
        return sb.toString();
    }
}

