/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.routesearch;

import java.util.PriorityQueue;
import openlr.collection.OpenLongIntHashMap;
import openlr.map.Line;
import openlr.map.utils.PQElem;

public class RouteSearchData {
    private static final int PQ_INITIAL_SIZE = 11;
    private final PriorityQueue<PQElem> open = new PriorityQueue(11, new PQElem.PQElemComparator());
    private final OpenLongIntHashMap bestValues = new OpenLongIntHashMap();

    public final void addToOpen(PQElem elem) {
        this.open.add(elem);
        this.bestValues.put(elem.getLine().getID(), elem.getSecondVal());
    }

    public final boolean isOpenEmpty() {
        return this.open.isEmpty();
    }

    public final PQElem pollElement() {
        return this.open.poll();
    }

    public final boolean hasLengthValue(Line l) {
        return this.bestValues.containsKey(l.getID());
    }

    public final int getLengthValue(Line l) {
        return this.bestValues.get(l.getID());
    }

    public final void updateInOpen(PQElem elem) {
        this.open.remove(elem);
        this.addToOpen(elem);
    }

    public final PriorityQueue<PQElem> getOpenList() {
        return this.open;
    }
}

