/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.routesearch;

import java.util.ArrayList;
import java.util.List;
import openlr.map.Line;
import openlr.map.utils.PathUtils;

public class RouteSearchResult {
    private final List<Line> theRoute = new ArrayList<Line>();
    private final Line theIntermediate;
    private final int intermediatePos;
    private final RouteSearchReturnCode result;
    private final Line secondIntermediate;

    RouteSearchResult(RouteSearchReturnCode code) {
        this.theIntermediate = null;
        this.intermediatePos = -1;
        this.result = code;
        this.secondIntermediate = null;
    }

    RouteSearchResult(RouteSearchReturnCode code, List<Line> route, Line line, int pos) {
        this.result = code;
        this.intermediatePos = pos;
        this.theIntermediate = line;
        this.theRoute.addAll(route);
        this.secondIntermediate = null;
    }

    public RouteSearchResult(RouteSearchReturnCode code, List<Line> route) {
        this.result = code;
        this.intermediatePos = -1;
        this.theIntermediate = null;
        this.theRoute.addAll(route);
        this.secondIntermediate = null;
    }

    public RouteSearchResult(RouteSearchReturnCode code, List<Line> route, Line line, int pos, Line second) {
        this.result = code;
        this.intermediatePos = pos;
        this.theIntermediate = line;
        this.theRoute.addAll(route);
        this.secondIntermediate = second;
    }

    public final List<Line> getRoute() {
        return this.theRoute;
    }

    public final int getRouteLength() {
        return PathUtils.getLength(this.theRoute);
    }

    public final Line getIntermediate() {
        return this.theIntermediate;
    }

    public final int getIntermediatePos() {
        return this.intermediatePos;
    }

    public final RouteSearchReturnCode getResult() {
        return this.result;
    }

    public final boolean hasSecondIntermediate() {
        return this.secondIntermediate != null;
    }

    public final Line getSecondIntermediate() {
        return this.secondIntermediate;
    }

    public static enum RouteSearchReturnCode {
        ROUTE_FOUND,
        INTERMEDIATE_FOUND,
        NO_ROUTE_FOUND,
        NOT_CALCULATED;

    }
}

