/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import java.util.ArrayList;
import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.data.ExpansionHelper;
import openlr.encoder.data.LocRefData;
import openlr.encoder.data.LocRefPoint;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.routesearch.RouteSearch;
import openlr.encoder.routesearch.RouteSearchResult;
import openlr.location.Location;
import openlr.map.FunctionalRoadClass;
import openlr.map.GeoCoordinates;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.Node;
import openlr.map.utils.NodeCheck;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public abstract class AbstractEncoder {
    private static final Logger LOG = Logger.getLogger(AbstractEncoder.class);
    private static final FunctionalRoadClass.FrcComparator FRC_COMPARATOR = new FunctionalRoadClass.FrcComparator();

    public abstract RawLocationReference doEncoding(Location var1, OpenLREncoderProperties var2, MapDatabase var3) throws OpenLRProcessingException;

    protected final List<LocRefPoint> generateLocRef(LocRefData locRefData, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        ArrayList<LocRefPoint> locRefPoints = new ArrayList<LocRefPoint>();
        List<Object> remainingLocation = new ArrayList<Line>(ExpansionHelper.getExpandedLocation(locRefData));
        Line finalDest = (Line)remainingLocation.get(remainingLocation.size() - 1);
        int maxLength = properties.getMaximumDistanceLRP();
        FunctionalRoadClass lowestPossibleFRC = this.calcLFRC(remainingLocation);
        while (!remainingLocation.isEmpty()) {
            RouteSearch rs = new RouteSearch(remainingLocation);
            RouteSearchResult rsResult = rs.calculateRoute(lowestPossibleFRC);
            RouteSearchResult.RouteSearchReturnCode searchResult = rsResult.getResult();
            switch (searchResult) {
                case INTERMEDIATE_FOUND: {
                    List<LocRefPoint> newPoints = this.handleIntermediateFound(remainingLocation, rsResult, properties);
                    locRefPoints.addAll(newPoints);
                    int pos = rsResult.getIntermediatePos();
                    remainingLocation = remainingLocation.subList(pos, remainingLocation.size());
                    break;
                }
                case NO_ROUTE_FOUND: {
                    throw this.createRuntimeException(locRefData.getID(), OpenLREncoderProcessingException.EncoderProcessingError.NO_ROUTE_FOUND_ERROR);
                }
                case ROUTE_FOUND: {
                    LocRefPoint newLRP = new LocRefPoint(remainingLocation, properties);
                    locRefPoints.add(newLRP);
                    remainingLocation = remainingLocation.subList(remainingLocation.size(), remainingLocation.size());
                    break;
                }
            }
        }
        LocRefPoint lastLRP = new LocRefPoint(finalDest, properties);
        locRefPoints.add(lastLRP);
        ArrayList<LocRefPoint> checkedList = new ArrayList<LocRefPoint>();
        for (int i = 0; i < locRefPoints.size() - 1; ++i) {
            LocRefPoint lrp = (LocRefPoint)locRefPoints.get(i);
            if (lrp.getDistanceToNext() > maxLength) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("maximum distance between two LRP is exceeded (distance is: " + lrp.getDistanceToNext() + ")"));
                }
                List<Line> oldRoute = lrp.getRoute();
                List<LocRefPoint> newLRPs = this.determineNewIntermediates(properties, oldRoute);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("added " + (newLRPs.size() - 1)));
                }
                checkedList.addAll(newLRPs);
                continue;
            }
            checkedList.add(lrp);
        }
        checkedList.add((LocRefPoint)locRefPoints.get(locRefPoints.size() - 1));
        int lrpCount = 1;
        for (int i = 0; i < checkedList.size() - 1; ++i) {
            LocRefPoint lrp = (LocRefPoint)checkedList.get(i);
            lrp.setNextLRP((LocRefPoint)checkedList.get(i + 1));
            lrp.setSequenceNumber(lrpCount);
            ++lrpCount;
        }
        ((LocRefPoint)checkedList.get(checkedList.size() - 1)).setSequenceNumber(lrpCount);
        return checkedList;
    }

    private List<LocRefPoint> determineNewIntermediates(OpenLREncoderProperties properties, List<Line> oldRoute) throws OpenLRProcessingException {
        if (oldRoute.isEmpty()) {
            throw new IllegalArgumentException("old route is empty");
        }
        boolean finished = false;
        ArrayList<Object> subRoute = new ArrayList<Line>();
        int subDist = 0;
        int oldRouteSize = oldRoute.size();
        int oldRoutePos = 0;
        ArrayList<LocRefPoint> newLRPs = new ArrayList<LocRefPoint>();
        int maxDist = properties.getMaximumDistanceLRP();
        while (!finished) {
            Line next = oldRoute.get(oldRoutePos);
            int lineLength = next.getLineLength();
            if (subDist + lineLength > maxDist || ++oldRoutePos >= oldRouteSize) {
                if (subDist + lineLength > maxDist) {
                    if (subDist > 0 && !subRoute.isEmpty()) {
                        LocRefPoint firstLRP = new LocRefPoint(subRoute, properties);
                        newLRPs.add(firstLRP);
                        subRoute = new ArrayList();
                        subDist = 0;
                    }
                    int consumedLength = 0;
                    int counter = 0;
                    ArrayList<Line> path = new ArrayList<Line>(1);
                    path.add(next);
                    LocRefPoint startLRP = new LocRefPoint(path, properties);
                    newLRPs.add(startLRP);
                    while (subDist + lineLength - consumedLength > maxDist) {
                        GeoCoordinates point = next.getGeoCoordinateAlongLine(++counter * maxDist);
                        LocRefPoint newIntermediate = new LocRefPoint(next, point.getLongitudeDeg(), point.getLatitudeDeg(), properties, false);
                        newLRPs.add(newIntermediate);
                        consumedLength += maxDist;
                    }
                    if (oldRoutePos >= oldRouteSize) {
                        finished = true;
                        continue;
                    }
                    subDist = lineLength - consumedLength;
                    continue;
                }
                if (subDist + lineLength <= maxDist && oldRoutePos == oldRouteSize) {
                    subRoute.add(next);
                    finished = true;
                } else {
                    oldRoutePos = NodeCheck.isValidNode((Node)((Line)subRoute.get(subRoute.size() - 1)).getEndNode()) ? --oldRoutePos : this.handleInvalidIntermediateNode(oldRoutePos, subRoute);
                }
                LocRefPoint newIntermediate = new LocRefPoint(subRoute, properties);
                newLRPs.add(newIntermediate);
                if (finished) continue;
                subRoute = new ArrayList();
                subDist = 0;
                continue;
            }
            subDist += lineLength;
            subRoute.add(next);
        }
        return newLRPs;
    }

    private int handleInvalidIntermediateNode(int routePos, List<Line> subRoute) {
        int oldRoutePos = routePos;
        int validNodePos = this.checkBackwardForValidNode(subRoute) + 1;
        if (validNodePos > 0) {
            int resetCounterBy = subRoute.size() - validNodePos + 1;
            ArrayList<Line> unusedLines = new ArrayList<Line>(resetCounterBy);
            unusedLines.addAll(subRoute.subList(validNodePos, subRoute.size()));
            subRoute.removeAll(unusedLines);
            oldRoutePos -= resetCounterBy;
        } else {
            --oldRoutePos;
        }
        return oldRoutePos;
    }

    private int checkBackwardForValidNode(List<Line> route) {
        int pos = route.size() - 1;
        while (!NodeCheck.isValidNode((Node)route.get(pos).getEndNode()) && --pos >= 0) {
        }
        return pos;
    }

    private FunctionalRoadClass calcLFRC(List<Line> remainingLocation) {
        FunctionalRoadClass lfrc = FunctionalRoadClass.getHighestFrc();
        for (Line next : remainingLocation) {
            if (FRC_COMPARATOR.compare(next.getFRC(), lfrc) >= 0) continue;
            lfrc = next.getFRC();
        }
        return lfrc.lower().lower();
    }

    private OpenLREncoderProcessingException createRuntimeException(String id, OpenLREncoderProcessingException.EncoderProcessingError t) {
        LOG.error((Object)("Encoding error (id:" + id + ") -- " + t.toString()));
        return new OpenLREncoderProcessingException(t);
    }

    private List<LocRefPoint> handleIntermediateFound(List<Line> currentLocation, RouteSearchResult rd, OpenLREncoderProperties properties) throws OpenLRProcessingException {
        ArrayList<LocRefPoint> locRefPoints = new ArrayList<LocRefPoint>();
        List<Line> theRoute = rd.getRoute();
        if (rd.hasSecondIntermediate()) {
            Line secondLRPline = rd.getSecondIntermediate();
            int pos = currentLocation.indexOf(secondLRPline);
            if (pos < 0) {
                throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INTERMEDIATE_CALCULATION_FAILED);
            }
            ArrayList<Line> newRoute1 = new ArrayList<Line>(theRoute.subList(0, pos));
            ArrayList<Line> newRoute2 = new ArrayList<Line>(theRoute.subList(pos, theRoute.size()));
            LocRefPoint newLRP1 = new LocRefPoint(newRoute1, properties);
            LocRefPoint newLRP2 = new LocRefPoint(newRoute2, properties);
            locRefPoints.add(newLRP1);
            locRefPoints.add(newLRP2);
        } else {
            LocRefPoint newLRP = new LocRefPoint(theRoute, properties);
            locRefPoints.add(newLRP);
        }
        return locRefPoints;
    }
}

