/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.CircleLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawCircleLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;

public class CircleEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        CircleLocationCheck locCheck = new CircleLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        GeoCoordinatesImpl gc = null;
        try {
            gc = new GeoCoordinatesImpl(location.getCenterPoint().getLongitudeDeg(), location.getCenterPoint().getLatitudeDeg());
        }
        catch (InvalidMapDataException e) {
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INVALID_MAP_DATA, e);
        }
        RawCircleLocRef rawLocRef = new RawCircleLocRef(location.getID(), (GeoCoordinates)gc, location.getRadius());
        return rawLocRef;
    }
}

