/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.data.LocRefData;
import openlr.encoder.locRefAdjust.LocationReferenceAdjust;
import openlr.encoder.locRefAdjust.worker.ClosedLineLocRefAdjust;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.ClosedLineLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawClosedLineLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;

public class ClosedLineEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        ClosedLineLocationCheck locCheck = new ClosedLineLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        LocRefData lrd = new LocRefData(location);
        lrd.setLocRefPoints(this.generateLocRef(lrd, prop));
        ClosedLineLocRefAdjust locRefAdjust = new ClosedLineLocRefAdjust();
        ((LocationReferenceAdjust)locRefAdjust).adjustLocationReference(prop, lrd);
        RawClosedLineLocRef rawLocRef = new RawClosedLineLocRef(location.getID(), lrd.getLocRefPoints());
        return rawLocRef;
    }
}

