/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.GridLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawGridLocRef;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;

public class GridEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        GridLocationCheck locCheck = new GridLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        RawGridLocRef rawLocRef = new RawGridLocRef(location.getID(), location.getLowerLeftPoint(), location.getUpperRightPoint(), location.getNumberOfColumns(), location.getNumberOfRows());
        return rawLocRef;
    }
}

