/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.data.AdjustOffsets;
import openlr.encoder.data.ExpansionHelper;
import openlr.encoder.data.LocRefData;
import openlr.encoder.locRefAdjust.LocationReferenceAdjust;
import openlr.encoder.locRefAdjust.worker.LineLocRefAdjust;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.LineLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLineLocRef;
import openlr.rawLocRef.RawLocationReference;

public class LineEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        LineLocationCheck locCheck = new LineLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        retCode = ((LocationCheck)locCheck).checkOffsets(prop, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        LocRefData locRefData = new LocRefData(location);
        locRefData.setAdjustedLocation(AdjustOffsets.adjustOffsets(location, prop));
        locRefData.setExpansion(ExpansionHelper.createExpandedLocation(prop, mdb, locRefData));
        locRefData.setLocRefPoints(this.generateLocRef(locRefData, prop));
        LineLocRefAdjust locRefAdjust = new LineLocRefAdjust();
        ((LocationReferenceAdjust)locRefAdjust).adjustLocationReference(prop, locRefData);
        RawLineLocRef rawLocRef = new RawLineLocRef(locRefData.getID(), locRefData.getLocRefPoints(), locRefData.getOffsets());
        return rawLocRef;
    }
}

