/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import java.util.List;
import openlr.LocationReferencePoint;
import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.data.ExpansionHelper;
import openlr.encoder.data.LocRefData;
import openlr.encoder.data.LocRefPoint;
import openlr.encoder.locRefAdjust.LocationReferenceAdjust;
import openlr.encoder.locRefAdjust.worker.PointAlongLocRefAdjust;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.PointAlongLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPointAlongLocRef;

public class PointAlongEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        PointAlongLocationCheck locCheck = new PointAlongLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        retCode = ((LocationCheck)locCheck).checkOffsets(prop, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        LocRefData lrd = new LocRefData(location);
        lrd.setExpansion(ExpansionHelper.createExpandedLocation(prop, mdb, lrd));
        lrd.setLocRefPoints(this.generateLocRef(lrd, prop));
        PointAlongLocRefAdjust locRefAdjust = new PointAlongLocRefAdjust();
        ((LocationReferenceAdjust)locRefAdjust).adjustLocationReference(prop, lrd);
        List<LocRefPoint> lrps = lrd.getLocRefPoints();
        RawPointAlongLocRef rawLocRef = new RawPointAlongLocRef(location.getID(), (LocationReferencePoint)lrps.get(0), (LocationReferencePoint)lrps.get(1), lrd.getOffsets(), location.getSideOfRoad(), location.getOrientation());
        return rawLocRef;
    }
}

