/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import java.util.List;
import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.PolygonLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawPolygonLocRef;

public class PolygonEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        PolygonLocationCheck locCheck = new PolygonLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        List cornerCoords = location.getCornerPoints();
        RawPolygonLocRef rawLocRef = new RawPolygonLocRef(location.getID(), cornerCoords);
        return rawLocRef;
    }
}

