/*
 * Decompiled with CFR 0.152.
 */
package openlr.encoder.worker;

import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.encoder.OpenLREncoderProcessingException;
import openlr.encoder.locationCheck.CheckResult;
import openlr.encoder.locationCheck.LocationCheck;
import openlr.encoder.locationCheck.worker.RectangleLocationCheck;
import openlr.encoder.properties.OpenLREncoderProperties;
import openlr.encoder.worker.AbstractEncoder;
import openlr.location.Location;
import openlr.map.GeoCoordinates;
import openlr.map.GeoCoordinatesImpl;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawInvalidLocRef;
import openlr.rawLocRef.RawLocationReference;
import openlr.rawLocRef.RawRectangleLocRef;

public class RectangleEncoder
extends AbstractEncoder {
    @Override
    public final RawLocationReference doEncoding(Location location, OpenLREncoderProperties prop, MapDatabase mdb) throws OpenLRProcessingException {
        RectangleLocationCheck locCheck = new RectangleLocationCheck();
        CheckResult retCode = ((LocationCheck)locCheck).check(prop, mdb, location);
        if (!retCode.checkPassed()) {
            RawInvalidLocRef invalid = new RawInvalidLocRef(location.getID(), (StatusCode)retCode.getError(), location.getLocationType());
            return invalid;
        }
        RawRectangleLocRef rawLocRef = null;
        try {
            rawLocRef = new RawRectangleLocRef(location.getID(), (GeoCoordinates)new GeoCoordinatesImpl(location.getLowerLeftPoint().getLongitudeDeg(), location.getLowerLeftPoint().getLatitudeDeg()), (GeoCoordinates)new GeoCoordinatesImpl(location.getUpperRightPoint().getLongitudeDeg(), location.getUpperRightPoint().getLatitudeDeg()));
        }
        catch (InvalidMapDataException e) {
            throw new OpenLREncoderProcessingException(OpenLREncoderProcessingException.EncoderProcessingError.INVALID_MAP_DATA, e);
        }
        return rawLocRef;
    }
}

