/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import openlr.LocationReference;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.PhysicalDecoder;
import openlr.PhysicalFormatException;
import openlr.StatusCode;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.LocationDatabase;
import openlr.decoder.OpenLRDecoderParameter;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.CircleDecoder;
import openlr.decoder.worker.ClosedLineDecoder;
import openlr.decoder.worker.GeoCoordDecoder;
import openlr.decoder.worker.GridDecoder;
import openlr.decoder.worker.LineDecoder;
import openlr.decoder.worker.PoiAccessDecoder;
import openlr.decoder.worker.PointAlongDecoder;
import openlr.decoder.worker.PolygonDecoder;
import openlr.decoder.worker.RectangleDecoder;
import openlr.location.InvalidLocation;
import openlr.location.Location;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public final class OpenLRDecoder
implements openlr.OpenLRDecoder {
    private static final Logger LOG = Logger.getLogger(OpenLRDecoder.class);
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 3;
    private static final int PATCH_VERSION = 0;

    public Location decode(OpenLRDecoderParameter parameter, LocationReference locRef) throws OpenLRProcessingException {
        OpenLRDecoderProperties properties = new OpenLRDecoderProperties(parameter.getConfiguration());
        return this.decode(parameter, properties, locRef);
    }

    private Location decode(OpenLRDecoderParameter parameter, OpenLRDecoderProperties properties, LocationReference locRef) throws OpenLRProcessingException {
        List<PhysicalDecoder> physDecoder = parameter.getPhysicalDecoders();
        if (physDecoder.isEmpty()) {
            physDecoder = OpenLRDecoder.resolvePhysicalDecoder();
        }
        if (physDecoder.isEmpty()) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.NO_PHYSICAL_DECODER_DETECTED, "No physical decoder found!");
        }
        return this.decodeRaw(parameter, properties, this.resolveRawFormat(locRef, physDecoder));
    }

    public List<Location> decode(OpenLRDecoderParameter parameter, List<LocationReference> locRefs) throws OpenLRProcessingException {
        ArrayList<Location> locations = new ArrayList<Location>();
        OpenLRDecoderProperties properties = new OpenLRDecoderProperties(parameter.getConfiguration());
        for (LocationReference locRef : locRefs) {
            locations.add(this.decode(parameter, properties, locRef));
        }
        return locations;
    }

    public List<Location> decodeRaw(OpenLRDecoderParameter parameter, List<RawLocationReference> locRefs) throws OpenLRProcessingException {
        ArrayList<Location> locations = new ArrayList<Location>();
        OpenLRDecoderProperties properties = new OpenLRDecoderProperties(parameter.getConfiguration());
        for (RawLocationReference locRef : locRefs) {
            locations.add(this.decodeRaw(parameter, properties, locRef));
        }
        return locations;
    }

    public Location decodeRaw(OpenLRDecoderParameter parameter, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        OpenLRDecoderProperties properties = new OpenLRDecoderProperties(parameter.getConfiguration());
        return this.decodeRaw(parameter, properties, rawLocRef);
    }

    private Location decodeRaw(OpenLRDecoderParameter parameter, OpenLRDecoderProperties properties, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        if (rawLocRef == null) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_LOC_REF_DATA, "No data found!");
        }
        if (!rawLocRef.isValid()) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.INVALID_LOCATION_REFERENCE_DATA, rawLocRef.getLocationType());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decode " + rawLocRef.getID()));
            if (!parameter.hasConfiguration()) {
                LOG.debug((Object)"No configuration available, use default values instead");
            }
        }
        int compTime4Cache = properties.getCompTime4Cache();
        long startTime = 0L;
        long endTime = 0L;
        Location decoded = null;
        if (parameter.hasLocationDatabase()) {
            LocationDatabase locDB = parameter.getLocationDatabase();
            decoded = locDB.getResult(rawLocRef);
            if (LOG.isDebugEnabled() && decoded != null) {
                LOG.debug((Object)"decoded location found in database");
            }
        }
        if (decoded == null) {
            AbstractDecoder worker = null;
            switch (rawLocRef.getLocationType()) {
                case GEO_COORDINATES: {
                    worker = new GeoCoordDecoder();
                    break;
                }
                case LINE_LOCATION: {
                    worker = new LineDecoder();
                    break;
                }
                case POI_WITH_ACCESS_POINT: {
                    worker = new PoiAccessDecoder();
                    break;
                }
                case POINT_ALONG_LINE: {
                    worker = new PointAlongDecoder();
                    break;
                }
                case CIRCLE: {
                    worker = new CircleDecoder();
                    break;
                }
                case RECTANGLE: {
                    worker = new RectangleDecoder();
                    break;
                }
                case GRID: {
                    worker = new GridDecoder();
                    break;
                }
                case POLYGON: {
                    worker = new PolygonDecoder();
                    break;
                }
                case CLOSED_LINE: {
                    worker = new ClosedLineDecoder();
                    break;
                }
                default: {
                    return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.INVALID_LOCATION_TYPE, LocationType.UNKNOWN);
                }
            }
            if (parameter.hasLocationDatabase() && compTime4Cache > 0) {
                startTime = System.currentTimeMillis();
            }
            decoded = worker.doDecoding(properties, parameter.getMapDatase(), rawLocRef);
            if (parameter.hasLocationDatabase() && compTime4Cache > 0) {
                endTime = System.currentTimeMillis();
            }
            if (parameter.hasLocationDatabase() && (compTime4Cache <= 0 || endTime - startTime > (long)compTime4Cache)) {
                parameter.getLocationDatabase().storeResult(rawLocRef, decoded);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"decoding finished");
            }
        }
        return decoded;
    }

    private RawLocationReference resolveRawFormat(LocationReference locRef, List<PhysicalDecoder> decoders) throws OpenLRProcessingException {
        if (locRef == null) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_LOC_REF_DATA);
        }
        RawLocationReference rawLocRef = null;
        for (PhysicalDecoder p : decoders) {
            if (!p.getDataFormatIdentifier().equals(locRef.getDataIdentifier())) continue;
            try {
                rawLocRef = p.decodeData(locRef);
            }
            catch (PhysicalFormatException e) {
                throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_LOC_REF_DATA, e);
            }
        }
        return rawLocRef;
    }

    public static List<PhysicalDecoder> resolvePhysicalDecoder() {
        ServiceLoader<PhysicalDecoder> decoderServices = ServiceLoader.load(PhysicalDecoder.class);
        ArrayList<PhysicalDecoder> decoders = new ArrayList<PhysicalDecoder>();
        for (PhysicalDecoder pd : decoderServices) {
            decoders.add(pd);
        }
        return decoders;
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 3;
    }

    public int getPatchVersion() {
        return 0;
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(1).append(".").append(3).append(".").append(0);
        return sb.toString();
    }
}

