/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.data;

import java.io.Serializable;
import java.util.Comparator;
import openlr.map.Line;

public class CandidateLine {
    public static final CandidateLine INVALID = new CandidateLine();
    private final Line line;
    private int rating;
    private int projectionAlongLine = Integer.MIN_VALUE;

    public CandidateLine(Line l, int r, int projection) {
        this.line = l;
        this.rating = r;
        this.projectionAlongLine = projection;
    }

    public CandidateLine(Line l, int r) {
        this.line = l;
        this.rating = r;
    }

    private CandidateLine() {
        this.line = null;
        this.rating = 0;
    }

    public final boolean isValid() {
        return this.line != null;
    }

    public final Line getLine() {
        return this.line;
    }

    public final int getRating() {
        return this.rating;
    }

    public final int getProjectionAlongLine() {
        return this.projectionAlongLine;
    }

    public final boolean hasProjectionAlongLine() {
        return this.projectionAlongLine >= 0;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("line: ").append(this.line.getID());
        sb.append(" rating: ").append(this.rating);
        sb.append(" projectionAlongLine: ").append(this.projectionAlongLine).append("m");
        return sb.toString();
    }

    public final boolean hasSameLine(CandidateLine cl) {
        return this.line.getID() == cl.getLine().getID();
    }

    public final void setNewRating(int rate, int lengthAlong) {
        this.rating = rate;
        this.projectionAlongLine = lengthAlong;
    }

    public static class CandidateLineComparator
    implements Comparator<CandidateLine>,
    Serializable {
        private static final long serialVersionUID = 1561170372253675757L;

        @Override
        public final int compare(CandidateLine o1, CandidateLine o2) {
            if (o1.rating > o2.rating) {
                return -1;
            }
            if (o1.rating < o2.rating) {
                return 1;
            }
            return 0;
        }
    }
}

