/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.data;

import cern.colt.function.IntObjectProcedure;
import cern.colt.map.OpenIntObjectHashMap;
import java.util.Collections;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.decoder.data.CandidateLine;

public class CandidateLinesResultSet {
    private static final CandidateLine.CandidateLineComparator CANDIDATE_LINE_COMPARATOR = new CandidateLine.CandidateLineComparator();
    private final OpenIntObjectHashMap candidateLines = new OpenIntObjectHashMap();

    public final void putCandidateLines(LocationReferencePoint lrp, List<CandidateLine> candidates) {
        Collections.sort(candidates, CANDIDATE_LINE_COMPARATOR);
        this.candidateLines.put(lrp.getSequenceNumber(), candidates);
    }

    public final List<CandidateLine> getCandidateLines(LocationReferencePoint lrp) {
        if (this.candidateLines.containsKey(lrp.getSequenceNumber())) {
            return (List)this.candidateLines.get(lrp.getSequenceNumber());
        }
        return Collections.EMPTY_LIST;
    }

    public final int getNumberOfCandidateLines(LocationReferencePoint lrp) {
        int number = 0;
        List list = (List)this.candidateLines.get(lrp.getSequenceNumber());
        if (list != null) {
            number = list.size();
        }
        return number;
    }

    public final CandidateLine getBestCandidateLine(LocationReferencePoint lrp) {
        CandidateLine line = null;
        List list = (List)this.candidateLines.get(lrp.getSequenceNumber());
        if (list != null && !list.isEmpty()) {
            line = (CandidateLine)list.get(0);
        }
        return line;
    }

    public final CandidateLine getCandidateLineAtIndex(LocationReferencePoint lrp, int idx) {
        CandidateLine line = null;
        List list = (List)this.candidateLines.get(lrp.getSequenceNumber());
        if (list != null && !list.isEmpty() && idx < list.size()) {
            line = (CandidateLine)list.get(idx);
        }
        return line;
    }

    public final boolean allCandidateLinesFound() {
        return this.candidateLines.forEachPair(new IntObjectProcedure(){

            public boolean apply(int first, Object second) {
                List list = (List)second;
                return list != null && !list.isEmpty();
            }
        });
    }

    public final String toDebug(LocationReferencePoint lrp) {
        StringBuilder sb = new StringBuilder();
        List list = (List)this.candidateLines.get(lrp.getSequenceNumber());
        for (int i = 0; i < list.size(); ++i) {
            CandidateLine cl = (CandidateLine)list.get(i);
            sb.append(cl.getRating()).append(": ").append(cl.getLine().getID()).append("\n");
        }
        return sb.toString();
    }
}

