/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.data;

import java.io.Serializable;
import java.util.Comparator;
import openlr.map.Node;

public class NodeWithDistance {
    private final Node node;
    private final int distance;

    public NodeWithDistance(Node n, int dist) {
        this.node = n;
        this.distance = dist;
    }

    public final Node getNode() {
        return this.node;
    }

    public final int getDistance() {
        return this.distance;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("node: ").append(this.node.getID());
        sb.append(" - distance: ").append(this.distance).append("m");
        return sb.toString();
    }

    public static class NodeWithDistanceComparator
    implements Comparator<NodeWithDistance>,
    Serializable {
        private static final long serialVersionUID = -3067041787960067220L;

        @Override
        public final int compare(NodeWithDistance o1, NodeWithDistance o2) {
            if (o1.distance < o2.distance) {
                return -1;
            }
            if (o1.distance > o2.distance) {
                return 1;
            }
            return 0;
        }
    }
}

