/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.data;

import cern.colt.map.OpenIntObjectHashMap;
import java.util.Collections;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.StatusCode;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.data.CandidateLine;
import openlr.map.Line;

public class ResolvedRoutes {
    private final OpenIntObjectHashMap calculatedShortestPaths = new OpenIntObjectHashMap();
    private Status statusCode = Status.PROCESSING;
    private DecoderReturnCode returnCode;

    public final void putRoute(LocationReferencePoint lrp, List<Line> route, CandidateLine start, CandidateLine end) {
        RouteWithCandidateLines rwl = new RouteWithCandidateLines(route, start, end);
        this.calculatedShortestPaths.put(lrp.getSequenceNumber(), (Object)rwl);
    }

    public final boolean allRoutesResolved() {
        return this.statusCode == Status.ALL_ROUTES_RESOLVED;
    }

    public final void setError(DecoderReturnCode retCode) {
        this.returnCode = retCode;
        this.statusCode = Status.ERROR;
    }

    public final void setAllResolved() {
        this.statusCode = Status.ALL_ROUTES_RESOLVED;
    }

    public final boolean hasErrorCode() {
        return this.statusCode == Status.ERROR;
    }

    public final Status getReturnCode() {
        return this.statusCode;
    }

    public final List<Line> getRoute(LocationReferencePoint lrp) {
        RouteWithCandidateLines rwl = (RouteWithCandidateLines)this.calculatedShortestPaths.get(lrp.getSequenceNumber());
        if (rwl == null) {
            return Collections.EMPTY_LIST;
        }
        return rwl.getRoute();
    }

    public final CandidateLine getCandidateStart(LocationReferencePoint lrp) throws OpenLRDecoderProcessingException {
        RouteWithCandidateLines rwl = (RouteWithCandidateLines)this.calculatedShortestPaths.get(lrp.getSequenceNumber());
        if (rwl == null) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_RESOLVE_ERROR);
        }
        return rwl.getStartCandidate();
    }

    public final CandidateLine getCandidateEnd(LocationReferencePoint lrp) throws OpenLRDecoderProcessingException {
        RouteWithCandidateLines rwl = (RouteWithCandidateLines)this.calculatedShortestPaths.get(lrp.getSequenceNumber());
        if (rwl == null) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_RESOLVE_ERROR);
        }
        return rwl.getEndCandidate();
    }

    public final StatusCode getErrorCode() {
        return this.returnCode;
    }

    private static final class RouteWithCandidateLines {
        private final List<Line> route;
        private CandidateLine start;
        private CandidateLine end;

        public RouteWithCandidateLines(List<Line> r, CandidateLine s, CandidateLine e) {
            this.route = r;
            this.start = s;
            this.end = e;
        }

        CandidateLine getStartCandidate() {
            return this.start;
        }

        CandidateLine getEndCandidate() {
            return this.end;
        }

        List<Line> getRoute() {
            return this.route;
        }
    }

    public static enum Status {
        ALL_ROUTES_RESOLVED,
        PROCESSING,
        ERROR;

    }
}

