/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.database;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private static final float HASH_TABLE_LOAD_FACTOR = 0.75f;
    private LinkedHashMap<K, V> map;
    private int cacheSize;

    public LRUCache(int cacheSizeValue) {
        this.cacheSize = cacheSizeValue;
        int hashTableCapacity = (int)Math.ceil((float)cacheSizeValue / 0.75f) + 1;
        this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return super.size() > LRUCache.this.cacheSize;
            }
        };
    }

    public final synchronized V get(K key) {
        return this.map.get(key);
    }

    public final synchronized void put(K key, V value) {
        this.map.put(key, value);
    }

    public final synchronized void clear() {
        this.map.clear();
    }

    public final synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final synchronized boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public final synchronized int size() {
        return this.map.size();
    }

    public final synchronized int getMaximumSize() {
        return this.cacheSize;
    }
}

