/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.database;

import openlr.decoder.LocationDatabase;
import openlr.decoder.database.LRUCache;
import openlr.location.Location;
import openlr.rawLocRef.RawLocationReference;

public class LocationDatabaseLRU
implements LocationDatabase {
    private final LRUCache<Integer, Location> db;

    public LocationDatabaseLRU(int cacheSize) {
        this.db = new LRUCache(cacheSize);
    }

    public final boolean containsLR(RawLocationReference locRef) {
        if (locRef == null || this.db.isEmpty()) {
            return false;
        }
        return this.db.containsKey(locRef.hashCode());
    }

    public final void storeResult(RawLocationReference locRef, Location loc) {
        if (loc == null || locRef == null) {
            return;
        }
        int key = locRef.hashCode();
        this.db.put(key, loc);
    }

    public final Location getResult(RawLocationReference locRef) {
        if (locRef == null) {
            throw new IllegalArgumentException();
        }
        int key1 = locRef.hashCode();
        return this.db.get(key1);
    }

    public final int getCacheSize() {
        return this.db.getMaximumSize();
    }

    public final int getCurrentNrEntries() {
        return this.db.size();
    }

    public final void clear() {
        this.db.clear();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("max size: ").append(this.getCacheSize());
        sb.append(" #entries: ").append(this.getCurrentNrEntries());
        return sb.toString();
    }
}

