/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.location;

import java.util.ArrayList;
import java.util.List;
import openlr.location.data.AffectedLines;
import openlr.map.Line;

public class AffectedLinesImpl
implements AffectedLines {
    public static final AffectedLines EMPTY = new AffectedLinesImpl();
    private final List<Line> coveredLines = new ArrayList<Line>();
    private final List<Line> intersectedLines = new ArrayList<Line>();

    private AffectedLinesImpl() {
    }

    public AffectedLinesImpl(List<? extends Line> covered, List<? extends Line> intersected) {
        this.intersectedLines.addAll(intersected);
        this.coveredLines.addAll(covered);
    }

    public final List<Line> getCoveredLines() {
        return this.coveredLines;
    }

    public final List<Line> getIntersectedLines() {
        return this.intersectedLines;
    }

    public final boolean hasCoveredLines() {
        return !this.coveredLines.isEmpty();
    }

    public final boolean hasIntersectedLines() {
        return !this.intersectedLines.isEmpty();
    }

    public final boolean isEmpty() {
        return !this.hasCoveredLines() && !this.hasIntersectedLines();
    }
}

