/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.properties;

import java.util.EnumMap;
import openlr.OpenLRProcessingException;
import openlr.decoder.properties.OpenLRDecoderProperty;
import openlr.decoder.rating.OpenLRRating;
import openlr.properties.OpenLRProperty;
import openlr.properties.OpenLRPropertyAccess;
import org.apache.commons.configuration.Configuration;

public class OpenLRDecoderProperties {
    private final int bearingDistance;
    private final int maxNodeDistance;
    private final int nodeFactor;
    private final int lineFactor;
    private final int frcVariance;
    private final int minimumAcceptedRating;
    private final int maxNumberRetries;
    private final float sameLineDegradation;
    private final float connectedRouteIncrease;
    private final int dnpVariance;
    private final int maxBearingDiff;
    private final EnumMap<OpenLRRating.RatingCategory, Integer> frcRating;
    private final EnumMap<OpenLRRating.RatingCategory, Integer> frcIntervals;
    private final EnumMap<OpenLRRating.RatingCategory, Integer> fowRating;
    private final EnumMap<OpenLRRating.RatingCategory, Integer> bearingIntervals;
    private final EnumMap<OpenLRRating.RatingCategory, Integer> bearingRating;
    private final boolean calcAffectedLines;
    private final float linesDirectlyFactor;
    private final int compTime4Cache;

    public OpenLRDecoderProperties(Configuration config) throws OpenLRProcessingException {
        this.bearingDistance = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.BEAR_DIST);
        this.maxNodeDistance = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.MAX_NODE_DIST);
        this.nodeFactor = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.NODE_FACTOR);
        this.lineFactor = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.LINE_FACTOR);
        this.frcVariance = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.FRC_VARIANCE);
        this.minimumAcceptedRating = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.MIN_ACC_RATING);
        this.maxNumberRetries = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.MAX_NR_RETRIES);
        this.sameLineDegradation = OpenLRPropertyAccess.getFloatPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.SAME_LINE_DEGRAD);
        this.connectedRouteIncrease = OpenLRPropertyAccess.getFloatPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.CONNECT_ROUTE_INC);
        this.dnpVariance = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.DNP_VARIANCE);
        this.maxBearingDiff = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.MAX_BEAR_DIFF);
        this.frcRating = new EnumMap(OpenLRRating.RatingCategory.class);
        this.fowRating = new EnumMap(OpenLRRating.RatingCategory.class);
        this.bearingRating = new EnumMap(OpenLRRating.RatingCategory.class);
        this.frcIntervals = new EnumMap(OpenLRRating.RatingCategory.class);
        this.bearingIntervals = new EnumMap(OpenLRRating.RatingCategory.class);
        for (OpenLRRating.RatingCategory cat : OpenLRRating.RatingCategory.values()) {
            this.fowRating.put(cat, OpenLRPropertyAccess.getIntegerPropertyValueFromMap((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.FOW_RATING, (String)cat.getIdentifier()));
            this.frcRating.put(cat, OpenLRPropertyAccess.getIntegerPropertyValueFromMap((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.FRC_RATING, (String)cat.getIdentifier()));
            this.bearingRating.put(cat, OpenLRPropertyAccess.getIntegerPropertyValueFromMap((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.BEAR_RATING, (String)cat.getIdentifier()));
            if (cat == OpenLRRating.RatingCategory.POOR) continue;
            this.frcIntervals.put(cat, OpenLRPropertyAccess.getIntegerPropertyValueFromMap((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.FRC_INTERVALS, (String)cat.getIdentifier()));
            this.bearingIntervals.put(cat, OpenLRPropertyAccess.getIntegerPropertyValueFromMap((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.BEAR_INTERVALS, (String)cat.getIdentifier()));
        }
        this.calcAffectedLines = OpenLRPropertyAccess.getBooleanPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.CALC_AFFECTED_LINES);
        this.linesDirectlyFactor = OpenLRPropertyAccess.getFloatPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.LINES_DIRECTLY_FACTOR);
        this.compTime4Cache = OpenLRPropertyAccess.getIntegerPropertyValue((Configuration)config, (OpenLRProperty)OpenLRDecoderProperty.COMP_TIME_4_CACHE);
    }

    public final int getBearingDistance() {
        return this.bearingDistance;
    }

    public final int getMaxNodeDistance() {
        return this.maxNodeDistance;
    }

    public final int getNodeFactor() {
        return this.nodeFactor;
    }

    public final int getLineFactor() {
        return this.lineFactor;
    }

    public final int getFrcVariance() {
        return this.frcVariance;
    }

    public final int getMinimumAcceptedRating() {
        return this.minimumAcceptedRating;
    }

    public final int getMaxNumberRetries() {
        return this.maxNumberRetries;
    }

    public final float getSameLineDegradation() {
        return this.sameLineDegradation;
    }

    public final float getConnectedRouteIncrease() {
        return this.connectedRouteIncrease;
    }

    public final int getDnpVariance() {
        return this.dnpVariance;
    }

    public final int getMaxBearingDiff() {
        return this.maxBearingDiff;
    }

    public final int getFrcRating(OpenLRRating.RatingCategory cat) {
        return this.frcRating.get((Object)cat);
    }

    public final int getFrcIntervals(OpenLRRating.RatingCategory interval) {
        return this.frcIntervals.get((Object)interval);
    }

    public final int getFowRating(OpenLRRating.RatingCategory cat) {
        return this.fowRating.get((Object)cat);
    }

    public final int getBearingRating(OpenLRRating.RatingCategory cat) {
        return this.bearingRating.get((Object)cat);
    }

    public final int getBearingIntervals(OpenLRRating.RatingCategory interval) {
        return this.bearingIntervals.get((Object)interval);
    }

    public final boolean isCalcAffectedLines() {
        return this.calcAffectedLines;
    }

    public final float getLinesDirectlyFactor() {
        return this.linesDirectlyFactor;
    }

    public final int getCompTime4Cache() {
        return this.compTime4Cache;
    }
}

