/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.properties;

import java.util.HashMap;
import openlr.properties.OpenLRProperty;
import openlr.properties.PropertyType;

public enum OpenLRDecoderProperty implements OpenLRProperty
{
    BEAR_DIST("BearingDistance", PropertyType.INTEGER, 20),
    MAX_NODE_DIST("MaxNodeDistance", PropertyType.INTEGER, 100),
    NODE_FACTOR("NodeFactor", PropertyType.INTEGER, 3),
    LINE_FACTOR("LineFactor", PropertyType.INTEGER, 3),
    FRC_VARIANCE("FRC_Variance", PropertyType.INTEGER, 2),
    MIN_ACC_RATING("MinimumAcceptedRating", PropertyType.INTEGER, 800),
    MAX_NR_RETRIES("MaxNumberRetries", PropertyType.INTEGER, 3),
    SAME_LINE_DEGRAD("SameLineDegradation", PropertyType.FLOAT, Float.valueOf(0.1f)),
    CONNECT_ROUTE_INC("ConnectedRouteIncrease", PropertyType.FLOAT, Float.valueOf(0.1f)),
    DNP_VARIANCE("DNPVariance", PropertyType.INTEGER, 118),
    MAX_BEAR_DIFF("maxBearingDiff", PropertyType.INTEGER, 90),
    FRC_RATING("FRC_Rating", PropertyType.INTEGER_BY_MAP, new HashMap<String, Integer>(){
        {
            this.put("Excellent", 100);
            this.put("Good", 75);
            this.put("Average", 50);
            this.put("Poor", 0);
        }
    }),
    FRC_INTERVALS("FRC_Intervals", PropertyType.INTEGER_BY_MAP, new HashMap<String, Integer>(){
        {
            this.put("Excellent", 0);
            this.put("Good", 1);
            this.put("Average", 2);
        }
    }),
    FOW_RATING("FOW_Rating", PropertyType.INTEGER_BY_MAP, new HashMap<String, Integer>(){
        {
            this.put("Excellent", 100);
            this.put("Good", 50);
            this.put("Average", 50);
            this.put("Poor", 25);
        }
    }),
    BEAR_RATING("Bearing_Rating", PropertyType.INTEGER_BY_MAP, new HashMap<String, Integer>(){
        {
            this.put("Excellent", 100);
            this.put("Good", 50);
            this.put("Average", 25);
            this.put("Poor", 0);
        }
    }),
    BEAR_INTERVALS("Bearing_Intervals", PropertyType.INTEGER_BY_MAP, new HashMap<String, Integer>(){
        {
            this.put("Excellent", 6);
            this.put("Good", 12);
            this.put("Average", 18);
        }
    }),
    CALC_AFFECTED_LINES("Calc_Affected_Lines", PropertyType.BOOLEAN, false),
    LINES_DIRECTLY_FACTOR("Lines_Directly_Factor", PropertyType.FLOAT, Float.valueOf(0.95f)),
    COMP_TIME_4_CACHE("CompTime4Cache", PropertyType.INTEGER, 0);

    private final String key;
    private final PropertyType propertyType;
    private final Object defaultValue;

    private OpenLRDecoderProperty(String s, PropertyType c, Object d) {
        this.key = s;
        this.propertyType = c;
        this.defaultValue = d;
    }

    public final String getKey() {
        return this.key;
    }

    public final PropertyType getPropertyType() {
        return this.propertyType;
    }

    public final Object getDefault() {
        return this.defaultValue;
    }
}

