/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.rating;

import openlr.LocationReferencePoint;
import openlr.OpenLRProcessingException;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.rating.FormOfWayRatingTable;
import openlr.decoder.rating.OpenLRRating;
import openlr.map.FormOfWay;
import openlr.map.FunctionalRoadClass;
import openlr.map.Line;
import openlr.map.utils.GeometryUtils;
import org.apache.log4j.Logger;

public class OpenLRRatingImpl
implements OpenLRRating {
    private static final int HALF_CIRCLE = 180;
    private static final int FULL_CIRCLE = 360;
    private static final Logger LOG = Logger.getLogger(OpenLRRatingImpl.class);
    private static final FormOfWayRatingTable FOW_RATING_TABLE = new FormOfWayRatingTable();

    @Override
    public final int getRating(OpenLRDecoderProperties properties, int distance, LocationReferencePoint p, Line line, int projectionAlongLine) throws OpenLRProcessingException {
        GeometryUtils.BearingDirection dir = null;
        dir = p.isLastLRP() ? GeometryUtils.BearingDirection.AGAINST_DIRECTION : GeometryUtils.BearingDirection.IN_DIRECTION;
        int nodeRating = this.calculateDistanceRating(properties, distance);
        int bearingRating = this.calculateBearingRating(properties, p.getBearing(), dir, line, projectionAlongLine);
        if (bearingRating < 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("bearing of a candidate line is out of range [" + line.getID() + "]"));
            }
            return -1;
        }
        int frcRating = this.calculateFRCRating(properties, p.getFRC(), line);
        int fowRating = this.calculateFOWRating(properties, p.getFOW(), line);
        int lineRating = bearingRating + frcRating + fowRating;
        int rating = properties.getNodeFactor() * nodeRating + properties.getLineFactor() * lineRating;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("total rating [" + line.getID() + "]: " + rating + "  (node: " + nodeRating + ", line: " + lineRating + ", bearing: " + bearingRating + ", frc: " + frcRating + ", fow: " + fowRating + ")"));
        }
        return rating;
    }

    private int calculateDistanceRating(OpenLRDecoderProperties properties, double distance) throws OpenLRProcessingException {
        int diff = properties.getMaxNodeDistance() - (int)Math.round(distance);
        return Math.max(0, diff);
    }

    private int calculateFRCRating(OpenLRDecoderProperties properties, FunctionalRoadClass frc, Line line) throws OpenLRProcessingException {
        int lineFRC = line.getFRC().getID();
        int diff = Math.abs(frc.getID() - lineFRC);
        OpenLRRating.RatingCategory bestCat = diff <= properties.getFrcIntervals(OpenLRRating.RatingCategory.EXCELLENT) ? OpenLRRating.RatingCategory.EXCELLENT : (diff <= properties.getFrcIntervals(OpenLRRating.RatingCategory.GOOD) ? OpenLRRating.RatingCategory.GOOD : (diff <= properties.getFrcIntervals(OpenLRRating.RatingCategory.AVERAGE) ? OpenLRRating.RatingCategory.AVERAGE : OpenLRRating.RatingCategory.POOR));
        return properties.getFrcRating(bestCat);
    }

    private int calculateFOWRating(OpenLRDecoderProperties properties, FormOfWay fow, Line line) throws OpenLRProcessingException {
        OpenLRRating.RatingCategory category = FOW_RATING_TABLE.getRating(fow, line.getFOW());
        return properties.getFowRating(category);
    }

    private int calculateBearingRating(OpenLRDecoderProperties properties, double bearing, GeometryUtils.BearingDirection dir, Line line, int projectionAlongLine) throws OpenLRProcessingException {
        double lineBearing = GeometryUtils.calculateLineBearing((Line)line, (GeometryUtils.BearingDirection)dir, (int)properties.getBearingDistance(), (int)projectionAlongLine);
        int diff = (int)Math.round(Math.abs(bearing - lineBearing));
        if (diff > 180) {
            diff = 360 - diff;
        }
        if (diff > properties.getMaxBearingDiff()) {
            return -1;
        }
        OpenLRRating.RatingCategory bestCat = diff <= properties.getBearingIntervals(OpenLRRating.RatingCategory.EXCELLENT) ? OpenLRRating.RatingCategory.EXCELLENT : (diff <= properties.getBearingIntervals(OpenLRRating.RatingCategory.GOOD) ? OpenLRRating.RatingCategory.GOOD : (diff <= properties.getBearingIntervals(OpenLRRating.RatingCategory.AVERAGE) ? OpenLRRating.RatingCategory.AVERAGE : OpenLRRating.RatingCategory.POOR));
        return properties.getBearingRating(bestCat);
    }
}

