/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.routesearch;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import openlr.decoder.routesearch.RouteSearchData;
import openlr.map.Line;
import openlr.map.Node;
import openlr.map.utils.GeometryUtils;
import openlr.map.utils.LineLinkedListElement;
import openlr.map.utils.PQElem;
import openlr.map.utils.PathUtils;
import org.apache.log4j.Logger;

public class RouteSearch {
    private static final Logger LOG = Logger.getLogger(RouteSearch.class);
    private RouteSearchResult state = RouteSearchResult.NOT_CALCULATED;
    private List<Line> theRoute = null;
    private int routeLength = -1;

    public final RouteSearchResult calculateRoute(Line startline, Line destline, int maxDistance, int lowestFRC, boolean isLast) {
        if (startline == null || destline == null) {
            this.state = RouteSearchResult.ROUTE_CONSTRUCTION_FAILED;
            return this.state;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("route calculation between start (" + startline.getID() + ") and destination (" + destline.getID() + ")"));
        }
        this.theRoute = null;
        this.routeLength = -1;
        this.state = RouteSearchResult.NOT_CALCULATED;
        RouteSearchData data = new RouteSearchData();
        Node e = null;
        e = isLast ? destline.getEndNode() : destline.getStartNode();
        double destX = e.getLongitudeDeg();
        double destY = e.getLatitudeDeg();
        int startLength = startline.getLineLength();
        PQElem startElem = new PQElem(startline, 0, startLength, null);
        data.addToOpen(startElem);
        while (!data.isOpenEmpty()) {
            PQElem actualElement = data.pollElement();
            if (isLast && actualElement.getLine().getID() == destline.getID()) {
                this.setRouteFound(actualElement);
                break;
            }
            if (!isLast && actualElement.getLine().getEndNode().equals(e)) {
                Iterator iter = actualElement.getLine().getNextLines();
                boolean destFound = false;
                while (iter.hasNext()) {
                    if (((Line)iter.next()).getID() != destline.getID()) continue;
                    destFound = true;
                    break;
                }
                if (!destFound) continue;
                this.setRouteFound(actualElement);
                break;
            }
            this.extractNextLines(maxDistance, lowestFRC, data, destX, destY, actualElement);
        }
        if (this.state == RouteSearchResult.NOT_CALCULATED) {
            this.state = RouteSearchResult.NO_ROUTE_FOUND;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("route search finished with status: " + this.state.name()));
        }
        return this.state;
    }

    private void extractNextLines(int maxDistance, int lowestFRC, RouteSearchData data, double destX, double destY, PQElem actualElement) {
        Iterator iterNext = actualElement.getLine().getNextLines();
        while (iterNext.hasNext()) {
            PQElem newElem;
            Line succ = (Line)iterNext.next();
            if (succ.getFRC().getID() > lowestFRC) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Stop route searching a path because of too high FRC " + succ.getFRC() + " at line " + succ.getID()));
                continue;
            }
            Node succEnd = succ.getEndNode();
            int succLength = succ.getLineLength();
            int newDist = actualElement.getSecondVal() + succLength;
            if (newDist > maxDistance) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Stop route searching a path because of reaching max search distance with " + newDist + " meters at line " + succ.getID()));
                continue;
            }
            int heurist = (int)Math.round(GeometryUtils.distance((double)destX, (double)destY, (double)succEnd.getLongitudeDeg(), (double)succEnd.getLatitudeDeg()));
            int newHeurVal = newDist + heurist;
            if (data.hasLengthValue(succ)) {
                if (newDist >= data.getLengthValue(succ)) continue;
                newElem = new PQElem(succ, newHeurVal, newDist, actualElement);
                data.updateInOpen(newElem);
                continue;
            }
            newElem = new PQElem(succ, newHeurVal, newDist, actualElement);
            data.addToOpen(newElem);
        }
    }

    private void setRouteFound(PQElem actualElement) {
        this.theRoute = PathUtils.constructPath((LineLinkedListElement)actualElement);
        if (this.theRoute == null) {
            LOG.error((Object)"route construction failed");
            this.state = RouteSearchResult.ROUTE_CONSTRUCTION_FAILED;
        } else {
            this.state = RouteSearchResult.ROUTE_FOUND;
            this.routeLength = actualElement.getSecondVal();
        }
    }

    public final List<Line> getCalculatedRoute() {
        if (this.state == RouteSearchResult.ROUTE_FOUND) {
            return this.theRoute;
        }
        return Collections.emptyList();
    }

    public final int getRouteLength() {
        return this.routeLength;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("route search state: ").append((Object)this.state);
        if (this.state == RouteSearchResult.ROUTE_FOUND) {
            sb.append(" route length: ").append(this.routeLength).append("m ");
            sb.append("[");
            for (int i = 0; i < this.theRoute.size(); ++i) {
                Line l = this.theRoute.get(i);
                sb.append(l.getID());
                if (i == this.theRoute.size() - 1) {
                    sb.append("]");
                    continue;
                }
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public static enum RouteSearchResult {
        ROUTE_FOUND,
        NO_ROUTE_FOUND,
        ROUTE_CONSTRUCTION_FAILED,
        NOT_CALCULATED;

    }
}

