/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.data.CandidateLine;
import openlr.decoder.data.CandidateLinePair;
import openlr.decoder.data.CandidateLinesResultSet;
import openlr.decoder.data.CandidateNodesResultSet;
import openlr.decoder.data.NodeWithDistance;
import openlr.decoder.data.ResolvedRoutes;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.rating.OpenLRRating;
import openlr.decoder.rating.OpenLRRatingImpl;
import openlr.decoder.routesearch.RouteSearch;
import openlr.decoder.worker.DecoderUtils;
import openlr.location.Location;
import openlr.map.FunctionalRoadClass;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.Node;
import openlr.map.utils.GeometryUtils;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public abstract class AbstractDecoder {
    private static final Logger LOG = Logger.getLogger(AbstractDecoder.class);
    private static final OpenLRRating RATING_FUNCTION = new OpenLRRatingImpl();

    public abstract Location doDecoding(OpenLRDecoderProperties var1, MapDatabase var2, RawLocationReference var3) throws OpenLRProcessingException;

    protected final CandidateNodesResultSet findCandidateNodes(OpenLRDecoderProperties properties, RawLocationReference rawLocRef, MapDatabase mdb) throws OpenLRProcessingException {
        int maxDistance = properties.getMaxNodeDistance();
        List points = rawLocRef.getLocationReferencePoints();
        CandidateNodesResultSet resultSet = new CandidateNodesResultSet();
        int lrpCount = 0;
        for (LocationReferencePoint p : points) {
            ++lrpCount;
            ArrayList<NodeWithDistance> closeByNodes = new ArrayList<NodeWithDistance>();
            int minDistance = Integer.MAX_VALUE;
            Iterator nodes = mdb.findNodesCloseByCoordinate(p.getLongitudeDeg(), p.getLatitudeDeg(), maxDistance);
            while (nodes.hasNext()) {
                Node n = (Node)nodes.next();
                int distance = (int)Math.round(GeometryUtils.distance((double)p.getLongitudeDeg(), (double)p.getLatitudeDeg(), (double)n.getLongitudeDeg(), (double)n.getLatitudeDeg()));
                if (distance < minDistance) {
                    minDistance = distance;
                }
                if (distance > maxDistance) continue;
                NodeWithDistance nwd = new NodeWithDistance(n, distance);
                closeByNodes.add(nwd);
            }
            resultSet.putCandidateNodes(p, closeByNodes);
            if (!LOG.isDebugEnabled()) continue;
            if (closeByNodes.isEmpty()) {
                LOG.warn((Object)("no candidate nodes found for node " + lrpCount + "[investigated: " + p.getSequenceNumber() + ", minDist: " + minDistance + "]"));
                continue;
            }
            LOG.debug((Object)("candidate nodes for node " + lrpCount + " (lon:" + p.getLongitudeDeg() + ", lat:" + p.getLatitudeDeg() + "): " + closeByNodes.size() + " - closest node distance: " + resultSet.getClosestNode(p).getDistance()));
        }
        return resultSet;
    }

    private List<CandidateLine> findCandidateLinesDirectly(OpenLRDecoderProperties properties, LocationReferencePoint lrp, MapDatabase mdb, List<CandidateLine> alreadyFound) throws OpenLRProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate lines directly");
        }
        ArrayList<CandidateLine> candidates = new ArrayList<CandidateLine>();
        int maxDistance = properties.getMaxNodeDistance();
        Iterator directLines = mdb.findLinesCloseByCoordinate(lrp.getLongitudeDeg(), lrp.getLatitudeDeg(), maxDistance);
        while (directLines.hasNext()) {
            Line line = (Line)directLines.next();
            int dist = line.distanceToPoint(lrp.getLongitudeDeg(), lrp.getLatitudeDeg());
            if (dist > maxDistance) continue;
            FunctionalRoadClass frc = line.getFRC();
            if (lrp.getLfrc() != null && frc.getID() > lrp.getLfrc().getID() + properties.getFrcVariance()) continue;
            int lengthAlongDseg = line.measureAlongLine(lrp.getLongitudeDeg(), lrp.getLatitudeDeg());
            int rating = RATING_FUNCTION.getRating(properties, dist, lrp, line, lengthAlongDseg);
            if (!alreadyFound.isEmpty()) {
                float factor = properties.getLinesDirectlyFactor();
                rating = Math.round(factor * (float)rating);
            }
            if (rating < properties.getMinimumAcceptedRating()) continue;
            CandidateLine rds = new CandidateLine(line, rating, lengthAlongDseg);
            boolean isNew = true;
            for (CandidateLine cl : alreadyFound) {
                if (!rds.hasSameLine(cl)) continue;
                isNew = false;
                if (cl.getRating() >= rating) break;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("new line rating has been found for " + cl.getLine().getID() + " [" + rating + "]"));
                }
                cl.setNewRating(rating, lengthAlongDseg);
                break;
            }
            if (!isNew) continue;
            candidates.add(rds);
        }
        return candidates;
    }

    public final CandidateLinesResultSet findCandidateLines(OpenLRDecoderProperties properties, RawLocationReference rawLocRef, CandidateNodesResultSet candidateNodes, MapDatabase mdb) throws OpenLRProcessingException {
        CandidateLinesResultSet resultSet = new CandidateLinesResultSet();
        List points = rawLocRef.getLocationReferencePoints();
        for (LocationReferencePoint p : points) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("investigate lrp " + p.getSequenceNumber() + " with: frc=" + p.getFRC() + " fow=" + p.getFOW() + " bearing=" + p.getBearing() + "\u00b0"));
            }
            ArrayList<CandidateLine> candidatesAtNodes = new ArrayList<CandidateLine>();
            for (NodeWithDistance nwd : candidateNodes.getCandidateNodes(p)) {
                Iterator linesIterator = nwd.getNode().getConnectedLines();
                while (linesIterator.hasNext()) {
                    Line line = (Line)linesIterator.next();
                    CandidateLine candidateLine = this.investigateline(properties, line, p, nwd);
                    if (!candidateLine.isValid()) continue;
                    candidatesAtNodes.add(candidateLine);
                }
            }
            List<CandidateLine> candidatesDirectly = this.findCandidateLinesDirectly(properties, p, mdb, candidatesAtNodes);
            ArrayList<CandidateLine> candidates = new ArrayList<CandidateLine>();
            candidates.addAll(candidatesDirectly);
            candidates.addAll(candidatesAtNodes);
            resultSet.putCandidateLines(p, candidates);
            if (candidates.isEmpty()) {
                LOG.error((Object)("no candidate lines found for lrp " + p.getSequenceNumber()));
                return resultSet;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(candidates.size() + " lines found for lrp " + p.getSequenceNumber() + "  [best rate: " + resultSet.getBestCandidateLine(p).getRating() + "]"));
        }
        if (LOG.isDebugEnabled()) {
            for (LocationReferencePoint p : points) {
                LOG.debug((Object)("Candidate lines for LRP " + p.getSequenceNumber()));
                LOG.debug((Object)resultSet.toDebug(p));
            }
        }
        return resultSet;
    }

    private CandidateLine investigateline(OpenLRDecoderProperties properties, Line line, LocationReferencePoint p, NodeWithDistance nwd) throws OpenLRProcessingException {
        if (line == null || p == null || nwd == null) {
            throw new IllegalArgumentException();
        }
        Node refNode = null;
        refNode = p.isLastLRP() ? line.getEndNode() : line.getStartNode();
        if (!refNode.equals(nwd.getNode())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("line " + line.getID() + " ignored [wrong direction]"));
            }
            return CandidateLine.INVALID;
        }
        FunctionalRoadClass frc = line.getFRC();
        if (!p.isLastLRP() && frc.getID() > p.getLfrc().getID() + properties.getFrcVariance()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("line " + line.getID() + " ignored [low frc (" + frc.getID() + ")]"));
            }
            return CandidateLine.INVALID;
        }
        int rating = RATING_FUNCTION.getRating(properties, nwd.getDistance(), p, line, 0);
        if (rating < properties.getMinimumAcceptedRating()) {
            return CandidateLine.INVALID;
        }
        CandidateLine cLine = new CandidateLine(line, rating);
        return cLine;
    }

    public final ResolvedRoutes resolveRoute(OpenLRDecoderProperties properties, RawLocationReference rawLocRef, CandidateLinesResultSet candidateLines, LocationType locType) throws OpenLRProcessingException {
        ResolvedRoutes resolvedRoutes = new ResolvedRoutes();
        List points = rawLocRef.getLocationReferencePoints();
        Line singleLine = this.checkForSingleLineOnly(candidateLines, points);
        int nrLRP = points.size();
        if (singleLine != null) {
            boolean first = true;
            for (int i = 0; i < nrLRP - 1; ++i) {
                LocationReferencePoint lrp = (LocationReferencePoint)points.get(i);
                LocationReferencePoint lrpNext = (LocationReferencePoint)points.get(i + 1);
                ArrayList<Line> resolvedPath = new ArrayList<Line>();
                if (first) {
                    resolvedPath.add(singleLine);
                    first = false;
                }
                resolvedRoutes.putRoute(lrp, resolvedPath, candidateLines.getBestCandidateLine(lrp), candidateLines.getBestCandidateLine(lrpNext));
            }
        } else {
            for (int i = 0; i < nrLRP - 1; ++i) {
                CandidateLine destCandidate;
                CandidateLinePair currentPair;
                CandidateLine startCandidate;
                LocationReferencePoint lrpPrev = null;
                if (i > 0) {
                    lrpPrev = (LocationReferencePoint)points.get(i - 1);
                }
                LocationReferencePoint lrp = (LocationReferencePoint)points.get(i);
                LocationReferencePoint lrpNext = (LocationReferencePoint)points.get(i + 1);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("investigate point " + lrp.getSequenceNumber() + " with expected distance: " + lrp.getDistanceToNext() + "m"));
                }
                int lfrc = lrp.getLfrc().getID() + properties.getFrcVariance();
                CandidateLine previousEndCandidate = null;
                if (lrpPrev != null) {
                    previousEndCandidate = resolvedRoutes.getCandidateEnd(lrpPrev);
                }
                List<CandidateLinePair> lrpPairs = DecoderUtils.resolveCandidatesOrder(lrp, lrpNext, candidateLines, previousEndCandidate, properties, locType);
                boolean routeSearchFinished = false;
                Iterator<CandidateLinePair> i$ = lrpPairs.iterator();
                while (i$.hasNext() && !(routeSearchFinished = this.checkCandidatePair(startCandidate = candidateLines.getCandidateLineAtIndex(lrp, (currentPair = i$.next()).getStartIndex()), destCandidate = candidateLines.getCandidateLineAtIndex(lrpNext, currentPair.getDestIndex()), properties, resolvedRoutes, lfrc, lrpPrev, lrp, lrpNext, previousEndCandidate))) {
                }
                if (!routeSearchFinished) {
                    LOG.error((Object)("cannot determine a route between lrp " + lrp.getSequenceNumber() + " and " + lrpNext.getSequenceNumber()));
                    resolvedRoutes.setError(DecoderReturnCode.NO_ROUTE_FOUND);
                    return resolvedRoutes;
                }
                if (!resolvedRoutes.hasErrorCode()) continue;
                return resolvedRoutes;
            }
        }
        resolvedRoutes.setAllResolved();
        return resolvedRoutes;
    }

    private Line checkForSingleLineOnly(CandidateLinesResultSet candidateLines, List<? extends LocationReferencePoint> points) {
        Line singleLine = null;
        for (LocationReferencePoint locationReferencePoint : points) {
            CandidateLine bestLine = candidateLines.getBestCandidateLine(locationReferencePoint);
            if (singleLine == null) {
                singleLine = bestLine.getLine();
                continue;
            }
            if (singleLine.getID() == bestLine.getLine().getID()) continue;
            return null;
        }
        return singleLine;
    }

    private boolean checkCandidatePair(CandidateLine startCandidate, CandidateLine destCandidate, OpenLRDecoderProperties properties, ResolvedRoutes resolvedRoutes, int lfrc, LocationReferencePoint lrpPrev, LocationReferencePoint lrp, LocationReferencePoint lrpNext, CandidateLine previousEndCandidate) throws OpenLRProcessingException {
        RouteSearch rsearch = new RouteSearch();
        Line startLine = startCandidate.getLine();
        Line destLine = destCandidate.getLine();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("test candidate pair: start-" + startLine.getID() + " - dest-" + destLine.getID()));
        }
        if (startLine.getID() == destLine.getID()) {
            this.handleSameStartEnd(resolvedRoutes, lrp, lrpNext, startCandidate, destCandidate);
            return true;
        }
        int maxDistance = DecoderUtils.calculateMaxLength(lrp, startCandidate, destCandidate, properties);
        RouteSearch.RouteSearchResult result = rsearch.calculateRoute(startLine, destLine, maxDistance, lfrc, lrpNext.isLastLRP());
        return this.handleRouteSearchResult(properties, resolvedRoutes, rsearch, lrpPrev, lrp, previousEndCandidate, startCandidate, destCandidate, result);
    }

    private boolean handleRouteSearchResult(OpenLRDecoderProperties properties, ResolvedRoutes resolvedRoutes, RouteSearch rsearch, LocationReferencePoint lrpPrev, LocationReferencePoint lrp, CandidateLine previousEndCandidate, CandidateLine startCandidate, CandidateLine destCandidate, RouteSearch.RouteSearchResult result) throws OpenLRProcessingException {
        boolean finished = false;
        if (result == RouteSearch.RouteSearchResult.NO_ROUTE_FOUND) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no route found");
            }
        } else if (result == RouteSearch.RouteSearchResult.ROUTE_CONSTRUCTION_FAILED) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"route construction error");
            }
        } else if (result == RouteSearch.RouteSearchResult.ROUTE_FOUND) {
            int rLength = DecoderUtils.determineRouteLength(rsearch, destCandidate);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  route found with length: " + rLength + "m"));
            }
            if (DecoderUtils.getMinDistanceNP(lrp, properties) <= rLength) {
                boolean retCode = this.handleValidRoute(properties, resolvedRoutes, rsearch, lrpPrev, lrp, previousEndCandidate, startCandidate, destCandidate);
                if (!retCode) {
                    resolvedRoutes.setError(DecoderReturnCode.NO_ALTERNATIVE_FOUND);
                }
                finished = true;
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"minimum route length error");
                    LOG.debug((Object)("  route length should be at least " + DecoderUtils.getMinDistanceNP(lrp, properties)));
                }
                resolvedRoutes.putRoute(lrp, rsearch.getCalculatedRoute(), startCandidate, destCandidate);
            }
        }
        return finished;
    }

    private void handleSameStartEnd(ResolvedRoutes resolvedRoutes, LocationReferencePoint lrp, LocationReferencePoint lrpNext, CandidateLine startCandidate, CandidateLine destCandidate) {
        if (lrpNext.isLastLRP()) {
            ArrayList<Line> path = new ArrayList<Line>(1);
            path.add(startCandidate.getLine());
            resolvedRoutes.putRoute(lrp, path, startCandidate, destCandidate);
        } else {
            resolvedRoutes.putRoute(lrp, new ArrayList<Line>(), startCandidate, destCandidate);
        }
    }

    private boolean handleValidRoute(OpenLRDecoderProperties properties, ResolvedRoutes resolvedRoutes, RouteSearch rsearch, LocationReferencePoint lrpPrev, LocationReferencePoint lrp, CandidateLine previousEndCandidate, CandidateLine startCandidate, CandidateLine destCandidate) throws OpenLRProcessingException {
        if (previousEndCandidate != null && !startCandidate.hasSameLine(previousEndCandidate)) {
            boolean retCode;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"start index has changed, need to redo previous route!!");
            }
            if (!(retCode = this.handleStartLineChange(startCandidate, lrpPrev, lrp, resolvedRoutes, properties))) {
                return false;
            }
        }
        resolvedRoutes.putRoute(lrp, rsearch.getCalculatedRoute(), startCandidate, destCandidate);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"route found");
        }
        return true;
    }

    private boolean handleStartLineChange(CandidateLine newCandidate, LocationReferencePoint lrpPrev, LocationReferencePoint lrp, ResolvedRoutes resolvedRoutes, OpenLRDecoderProperties properties) throws OpenLRProcessingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"start index has changed, need to redo previous route!!");
        }
        CandidateLine ppreviousCandidate = resolvedRoutes.getCandidateStart(lrpPrev);
        Line newStart = ppreviousCandidate.getLine();
        RouteSearch rsearchInner = new RouteSearch();
        int maxdistanceInner = DecoderUtils.calculateMaxLength(lrpPrev, ppreviousCandidate, newCandidate, properties);
        RouteSearch.RouteSearchResult resultRedo = rsearchInner.calculateRoute(newStart, newCandidate.getLine(), maxdistanceInner, lrpPrev.getLfrc().getID() + properties.getFrcVariance(), lrp.isLastLRP());
        if (resultRedo == RouteSearch.RouteSearchResult.ROUTE_FOUND && DecoderUtils.getMinDistanceNP(lrpPrev, properties) <= rsearchInner.getRouteLength()) {
            resolvedRoutes.putRoute(lrpPrev, rsearchInner.getCalculatedRoute(), ppreviousCandidate, newCandidate);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"new route found for previous lrp");
            }
            return true;
        }
        LOG.error((Object)"cannot find a proper route after start index change!");
        return false;
    }
}

