/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import openlr.OpenLRProcessingException;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.decoder.location.DecodedCircleLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.coverage.CircleCoverage;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.map.GeoCoordinates;
import openlr.map.InvalidMapDataException;
import openlr.map.MapDatabase;
import openlr.rawLocRef.RawLocationReference;

public class CircleDecoder
extends AbstractDecoder {
    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        GeoCoordinates center = rawLocRef.getCenterPoint();
        long radius = rawLocRef.getRadius();
        AffectedLines affectedLines = null;
        if (prop.isCalcAffectedLines()) {
            CircleCoverage coverage = new CircleCoverage(center, radius);
            affectedLines = coverage.getAffectedLines(mdb);
        } else {
            affectedLines = AffectedLinesImpl.EMPTY;
        }
        DecodedCircleLocation decoded = null;
        try {
            decoded = new DecodedCircleLocation(rawLocRef.getID(), affectedLines, center, radius);
        }
        catch (InvalidMapDataException e) {
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
        }
        return decoded;
    }
}

