/*
 * Decompiled with CFR 0.152.
 */
package openlr.decoder.worker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import openlr.LocationReferencePoint;
import openlr.LocationType;
import openlr.OpenLRProcessingException;
import openlr.StatusCode;
import openlr.decoder.DecoderReturnCode;
import openlr.decoder.OpenLRDecoderProcessingException;
import openlr.decoder.data.CandidateLinesResultSet;
import openlr.decoder.data.CandidateNodesResultSet;
import openlr.decoder.data.ResolvedRoutes;
import openlr.decoder.location.AffectedLinesImpl;
import openlr.decoder.location.DecodedClosedLineLocation;
import openlr.decoder.properties.OpenLRDecoderProperties;
import openlr.decoder.worker.AbstractDecoder;
import openlr.decoder.worker.coverage.ClosedLineCoverage;
import openlr.location.InvalidLocation;
import openlr.location.Location;
import openlr.location.data.AffectedLines;
import openlr.map.InvalidMapDataException;
import openlr.map.Line;
import openlr.map.MapDatabase;
import openlr.map.utils.IteratorHelper;
import openlr.map.utils.PathUtils;
import openlr.rawLocRef.RawLocationReference;
import org.apache.log4j.Logger;

public class ClosedLineDecoder
extends AbstractDecoder {
    private static final Logger LOG = Logger.getLogger(ClosedLineDecoder.class);

    @Override
    public final Location doDecoding(OpenLRDecoderProperties prop, MapDatabase mdb, RawLocationReference rawLocRef) throws OpenLRProcessingException {
        ResolvedRoutes resolvedRoutes;
        CandidateLinesResultSet candidateLines;
        if (mdb == null) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.NO_MAP_DATABASE_FOUND, LocationType.CLOSED_LINE);
        }
        List lrps = rawLocRef.getLocationReferencePoints();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate nodes");
        }
        CandidateNodesResultSet candidateNodes = this.findCandidateNodes(prop, rawLocRef, mdb);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"find candidate lines");
        }
        if (!(candidateLines = this.findCandidateLines(prop, rawLocRef, candidateNodes, mdb)).allCandidateLinesFound()) {
            return new InvalidLocation(rawLocRef.getID(), (StatusCode)DecoderReturnCode.NO_CANDIDATE_LINE_FOUND, LocationType.CLOSED_LINE);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"resolve routes");
        }
        if (!(resolvedRoutes = this.resolveRoute(prop, rawLocRef, candidateLines, LocationType.CLOSED_LINE)).allRoutesResolved()) {
            ArrayList<List<Line>> subRouteList = new ArrayList<List<Line>>();
            for (LocationReferencePoint p : lrps) {
                List<Line> path = resolvedRoutes.getRoute(p);
                subRouteList.add(path);
            }
            return new InvalidLocation(rawLocRef.getID(), resolvedRoutes.getErrorCode(), LocationType.CLOSED_LINE, subRouteList);
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        ArrayList<List<Line>> subRoutes = new ArrayList<List<Line>>();
        for (LocationReferencePoint p : lrps) {
            List<Line> path = resolvedRoutes.getRoute(p);
            lines.addAll(path);
            subRoutes.add(path);
        }
        if (!PathUtils.checkPathConnection(lines)) {
            LOG.error((Object)"resolved path is not connected");
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_DISCONNECTED);
        }
        Line firstLine = (Line)lines.get(0);
        Line lastLine = (Line)lines.get(lines.size() - 1);
        Iterator succLines = lastLine.getNextLines();
        if (!IteratorHelper.contains((Iterator)succLines, (Object)firstLine)) {
            LOG.error((Object)("unclosed closed location, not connected from " + lastLine.getID() + " to " + firstLine.getID()));
            throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.ROUTE_DISCONNECTED);
        }
        AffectedLines result = null;
        if (prop.isCalcAffectedLines()) {
            ClosedLineCoverage coverage = null;
            try {
                coverage = new ClosedLineCoverage(lines);
            }
            catch (InvalidMapDataException e) {
                throw new OpenLRDecoderProcessingException(OpenLRDecoderProcessingException.DecoderProcessingError.INVALID_MAP_DATA, e);
            }
            result = coverage.getAffectedLines(mdb);
        } else {
            result = AffectedLinesImpl.EMPTY;
        }
        DecodedClosedLineLocation decoded = new DecodedClosedLineLocation(rawLocRef.getID(), result, lines);
        return decoded;
    }
}

